using System;
using System.IO;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using nft.ui.mainframe;
using nft.ui.command;
using nft.framework.drawing;

namespace nft.contributions.ui
{
	/// <summary>
	/// CtbMenuItem ̊Tv̐łB
	/// </summary>
	public class CtbToolButton : Contribution
	{
		
		/// <summary>
		/// Contributes a menu and submenu items to mainmenu.
		/// 
		/// This contribution can add several items at once.
		/// </summary>
        public CtbToolButton(Plugin p, ParamsReader e)
            : base(p, e) {
                ParamsReader bar = e["bar"];
            parseNode(bar);
        }

        protected void parseNode(ParamsReader ebar)
		{
            string barname = ebar["name"].InnerTextOr("MAIN");
            ebar.OverWrite("parent", barname);
            ebar.OverWrite("id", ""); // set dummy id to parse successfuly
            CommandPathHint hint = new CommandPathHint(ebar);
            foreach (ParamsReader cn in ebar.EnumChildren("button"))
			{
				//ButtonCreationInfo info = parseButton(cn);
				//Main.mainFrame.AddToolButton(info,barname,after,before);
                hint.ID = cn["bid"].InnerTextOr("").Trim();
                CommandUI cui = parseButton(cn);
                CommandManager.TheInstance.RegisterCommand(this, cui, null, hint);

			}
		
		}

        protected CommandUI parseButton(ParamsReader item)
		{
			string _img = item["image"].InnerText.Trim();
            ImageRef iref = PluginImageManager.GetBundledImageRef(this, item,_img);
            string _cap = item["caption"].InnerTextOr("").Trim();
            TriggerCommandUI cui = new TriggerCommandUI(_cap, item.InnerText, iref);
            ParamsReader aidx = item["index"];
            if (!aidx.IsNull) {
                cui.IconIndex = int.Parse(aidx.InnerText);
            }
            return cui;
		}
	}
}
