using System;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using nft.ui.mainframe;
using nft.ui.command;
using System.Diagnostics;

namespace nft.contributions.ui
{
	/// <summary>
	/// CtbMenuItem ̊Tv̐łB
	/// </summary>
	public class CtbMenuItem : Contribution
	{
		
		public readonly string location;

		/// <summary>
		/// Contributes a menu and submenu items to mainmenu.
		/// 
		/// This contribution can add several items at once.
		/// </summary>
        public CtbMenuItem(Plugin p, ParamsReader e)
            : base(p, e) 
		{
            ParamsReader parent = e["location"];
            parent.OverWrite("id", ""); // set dummy id to parse successfuly
            CommandPathHint hint = new CommandPathHint(parent);
            ParamsReader entries = e["entries"];
            if ("ROOT".Equals(hint.Parent))
				hint.Parent = "";
            location = hint.Parent;
			parseNode(entries, hint);
		}

        protected void parseNode(ParamsReader node, CommandPathHint hint)
		{
            foreach (ParamsReader cn in node.EnumChildren("item"))
			{
                string mid = cn["mid"].InnerTextOr("").Trim();
                CommandUI cui = parseItem(cn);
                hint.ID = mid;
                CommandManager.TheInstance.RegisterCommand(this, mid, cui, hint, null);
                if(!cn["item"].IsNull)
				{
                    CommandPathHint h2 = new CommandPathHint("");
                    h2.Parent = hint.Parent + CommandManager.PathSepalator + mid;				
                    //string p2 = Main.mainFrame.RegisterMenuNode(_id,path,_cap,after,before);
                    parseNode(cn, h2);
				}
			}
		
		}

        protected CommandUI parseItem(ParamsReader item)
		{
            string _cap = item["caption"].InnerTextOr("").Trim();
            TriggerCommandUI cui = new TriggerCommandUI(_cap, item.InnerText, null);
            return cui;
		}
	}
}
