﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework;
using nft.core.view;
using nft.ui.mainframe;
using nft.impl.game;
using nft.core.geometry;
using System.Windows.Forms;

namespace nft.impl.view {
    public class GameViewFactory : IGameViewFactory {
        protected MainFrame MainFrame {
            get {
                return Main.mainFrame as MainFrame;
            }
        }

        public GameViewFactory(ParamsReader node) {
        }

        #region IGameViewFactory implementation
        public Type RegistType {
            get {
                return typeof(IGameViewFactory);
            }
        }

        public IView Create(core.game.IGame game, Location center) {
            GameViewPanel f = new GameViewPanel((GameImpl)game);
            MainFrame.AddView(game.Name, f);
            if (center != Location.UNPLACED) {
                // TODO scroll to the initial location
            }
            return f;
        }

        public IView Create(core.game.IGame game, Location center, int width, int height) {
            throw new NotImplementedException();
        }
        #endregion
    }
}
