using System;
using System.Diagnostics;
using nft.core.game;
using nft.core.schedule;
using nft.core;
using nft.framework;
using nft.util;

namespace nft.impl.game
{
	/// <summary>
	/// GameImpl ̊Tv̐łB
	/// </summary>
	[Serializable]
	public class GameImpl : IGame
	{
        protected Calendar calender;
        protected Clock clock;

		protected string name;
        protected TerrainMapImpl terrains;
        protected IPointerHandler activeHandler;
        protected ViewCollection views;
        protected bool modified;
        protected bool closed;

        public GameImpl(string name, ITerrainMap map, Calendar cal) {
            this.closed = false;
            this.modified = true;
            if (cal == null) cal = Calendar.ActiveCalendar;
            this.name = name;
            this.calender = cal;
            this.clock = this.calender.CreateNewClock(new Date());
            if (map is TerrainMapImpl)
                this.terrains = (TerrainMapImpl)map;
            else 
                this.terrains = new TerrainMapImpl(map);
            this.views = new ViewCollection(this);
        }

        public GameImpl(ITerrainMap map, Calendar cal)
            : this(I18n.T("GameManager", "NewGame"), map, cal) {
        }

        public TerrainMapImpl TerrainMap {
            get { return terrains; }
        }

		#region IGame o

		public void Start()
		{
			// TODO : this is test code
			for(int i = 0; i<30000; i++ )
			{
				//System.Threading.Thread.Sleep(100);
				clock.Tick(10);
			}
		}

		public virtual void Close()
		{
            closed = true;
            calender = null;
            clock = null;
            if (terrains != null) {
                terrains.Dispose();
                terrains = null;
            }
            if (views != null) {
                views.CloseAll();
                views = null;
            }
		}

        public bool ConfirmClose() {
            if (Closed) {
                return true;
            } else if(modified){
                string text = I18n.T("GameManager", "Unsaved game data will be lost. Are you sure?");
                modified = !UIUtil.ConfirmMessage(text, UIMessageType.warning, UIInformLevel.normal);
            }
            return !modified;
        }

        public bool Closed {
            get {
                return closed;
            }
        }

		public bool Modified
		{
			get
			{
				return modified;
			}
		}

		public nft.core.schedule.Clock Clock
		{
			get
			{
				return clock;
			}
		}

		public IClimateController ClimateController
		{
			get
			{
				// TODO:  GameImpl.OverrideTable getter ǉ܂B
				return null;
			}
		}

		public string Name
		{
			get{ return name; }
			set{ name = value; }
		}

        public IPointerHandler ActiveController {
            get {
                return activeHandler;
            }
            set {
                if (activeHandler != null) {
                    activeHandler.OnDetach(this);
                }
                activeHandler = value;
                activeHandler.OnAttach(this);
            }
        }

        public ViewCollection Views {
            get {
                return views;
            }
        }
        #endregion

    }
}
