using System;
using nft.core.geometry;

namespace nft.core.structure
{
	[Serializable]
	public class Lot
	{
		public Lot(string category, int level, Rect3D bounds )
		{
			Category = category;
			Level = level;
			Bounds = bounds;
		}

		public Lot(IStructureTemplate structure, Location loc )
		{
			ID = structure.ID;
			Level = structure.Level;
			Category = structure.Category;
			Bounds = new Rect3D(loc,structure.Size);
		}

		public readonly string ID;
		public readonly object Category;
		public readonly int Level;
		public readonly Rect3D Bounds;

        public virtual bool IsCollide(Lot other) {
            return Bounds.IsIntersect(other.Bounds) && other.IsCollideDetail(this);
        }

        /// <summary>
        /// This method will called for advanced collision check,
        /// and sholud be called ONLY when 'other' collide with the bounds of this lot.
        /// So the simplest way is 'return true' if inside of this bounds is completely exclusive.
        /// Or override in inherited class to implement complexed collision check.
        /// </summary>
        /// <param name="other"></param>
        /// <returns></returns>
        internal protected virtual bool IsCollideDetail(Lot other) {
            return true;
        }
	}
}
