﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework.drawing;
using nft.core.view;
using nft.contributions.graphics;
using nft.core.structure;
using nft.core.geometry;
using nft.core.graphics;
using System.Drawing;

namespace nft.core.graphics {
    public interface IStructureSkin {
        ITexture this[ISceneParams p] {
            get;
        }

        CtbStructureSkin Contribution {
            get;
        }

        ISiteDefiner SiteDefiner {
            get;
        }
    }

    public class StructureSkin : IStructureSkin {
        private CtbStructureSkin contrib;
        private InterCardinalDirection view_upper;

        public StructureSkin(CtbStructureSkin ctb, InterCardinalDirection upper) {
            this.contrib = ctb;
            this.view_upper = upper;
        }

        public CtbStructureSkin Contribution {
            get {
                return contrib;
            }
        }

        public virtual ITexture this[ISceneParams p] {
            get {
                int rot_idx = (int)view_upper;
                TextureSrc src = Contribution.TextureSources[rot_idx][p];
                GraphicManagerEx gm = GraphicManagerEx.GraphicManager;
                ResourceKey key = ResourceKey.CreateKey(Contribution, (ushort)rot_idx);
                ITexture tex = gm.CreateStaticTexture(key, src.ImageResource.Data[p].ImageSrc, src.Region);
                return tex;
            }
        }

        public ISiteDefiner SiteDefiner {
            get {
                return Contribution.SiteDefiner;
            }
        }

    }
}
