﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.core.view;
using nft.core.geometry;
using nft.framework;
using System.Windows.Forms;

namespace nft.core.game {
    public class ViewCollection : IEnumerable<IView>{
        static protected IGameViewFactory ViewFactory {
            get {
                return GlobalModules.GetModule(typeof(IGameViewFactory)) as IGameViewFactory;
            }
        }
        
        protected List<IView> views;
        protected IGame game;
        protected IView current;

        public ViewCollection(IGame _game) {
            game = _game;
            views = new List<IView>();
        }

        public IGame Game {
            get {
                return game;
            }
        }

        public virtual IView ActiveView {
            get {
                return current;
            }
            set {
                if (value != null) {
                    SetActive(value);
                }
            }
        }

        public virtual IView PrimaryView {
            get {
                return views.Count>0 ? views[0] : null;
            }
            /*
            set {
                throw new NotImplementedException();
            }
             */
        }

        public IView OpenNew() {
            IView v = CreateView();
            if (Add(v)) {
                SetActive(v);
                return v;
            }else{
                v.Close();
                return null;
            }
        }

        public void CloseAll() {
            foreach (IView v in views) {
                v.Close();
            }
            views.Clear();
        }

#region protected methods for override
        protected virtual bool Add(IView v) {            
            views.Add(v);
            return true;
        }

        protected virtual bool Remove(IView v) {
            return views.Remove(v);
        }

        protected virtual void SetActive(IView v) {
            if (views.Contains(v)) {
                current = v;
            } else {
                throw new InvalidOperationException("The view is not a member of collection.");
            }
        }

        protected virtual IView CreateView() {
            IView v = ViewFactory.Create(game, Location.UNPLACED);            
            v.OnClose += new ViewEventHandler(OnViewClose);
            v.QueryClose += new ViewQueryEventHandler(QueryViewClose);
            return v;
        }

        protected virtual void OnViewClose(ViewEventArgs ea) {
            IView v = ea.View;
            v.OnClose -= new ViewEventHandler(OnViewClose);
            v.QueryClose -= new ViewQueryEventHandler(OnViewClose);
            if (PrimaryView == v && !game.Closed) {
                game.Close();
            }
            Remove(v);
        }

        protected virtual void QueryViewClose(ViewQueryEventArgs ea) {
            IView v = ea.View;
            if (PrimaryView == v) {
                ea.Cancel = !game.ConfirmClose();
            }
        }
#endregion

        #region IEnumerable implementation
        public IEnumerator<IView>  GetEnumerator()
        {
            return views.GetEnumerator();
        }

        System.Collections.IEnumerator  System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion
    }
}
