﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework.plugin;
using nft.framework;
using nft.core.structure;
using nft.framework.drawing;
using nft.core.view;
using nft.core.geometry;
using nft.util;
using System.Diagnostics;
using nft.core;
using System.Drawing;
using nft.core.graphics;


namespace nft.contributions.graphics {
    public class CtbStructureSkin : Contribution{
        protected ISiteDefiner site;
        protected ConditionedResource<TextureSrc>[] textures = new ConditionedResource<TextureSrc>[4];
        //protected 

        public static InterCardinalDirection ToDirection(int rotate_val) {
            // if the value is in between 1 to 4, it is recognized as multiplier to PI (1PI = 90degree).
            // if the value is greater than 4, it is recognized as a value in degree.
            if (Math.Abs(rotate_val) > 4) {
                // Normalize degree value into PI multiplier (form -3 to 3).
                rotate_val /= 90;
                rotate_val %= 4;
            }
            // Normalize negative multiplier to positive.
            if (rotate_val < 0) rotate_val += 4;
            // Now, rotate_val have been converted to one of the values {0,1,2,3}.
            InterCardinalDirection ret = Direction.GetInterCardinalDirectionByZeroBaseIndex(rotate_val);
            return ret;
        }

        public CtbStructureSkin(Plugin owenr, ParamsReader reader)
            : base(owenr, reader) {
            site = ParseSite(reader);
            foreach (ParamsReader pr in reader["sprite"].Each) {
                string[] args =  pr["rotation"].InnerTextOr("0").Split(',');
                ConditionedResource<TextureSrc> _texture
                    = ConditionedResourceFactory.LoadAsConditiondResources<TextureSrc>(pr, new ResourceParser<TextureSrc>(ParseTexture));
                foreach (string arg in args) {
                    int rotate = int.Parse(arg);
                    InterCardinalDirection dir = CtbStructureSkin.ToDirection(rotate);
                    textures[Direction.ToZeroBaseIndex(dir)] = _texture;
                }
            }
        }

        protected virtual ISiteDefiner ParseSite(ParamsReader reader) {
            ParamsReader pr2 = reader["site"];
            return new BasicSiteDefiner(pr2);
        }

        protected virtual TextureSrc ParseTexture(ParamsReader reader) {
            ParamsReader imageref = reader["image"]["ref"];
            if (imageref.IsNull) {
                throw new PluginXmlException(this, reader, "An 'ref' attribute under 'image' element is required.");
            }
            Rectangle rect = SiteDefiner.GetTextureRect(reader);
            CtbImageResource res = (CtbImageResource)GetOtherContribution(imageref.InnerText);            
            return new TextureSrc(res, rect);
        }

        public ISiteDefiner SiteDefiner {
            get {
                return site;
            }
        }

        public ConditionedResource<TextureSrc>[] TextureSources {
            get {
                return textures;
            }
        }

        public StructureSkin GetRotated(InterCardinalDirection view_upper) {
            return new StructureSkin(this, view_upper);
        }

    }
}
