﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nft.framework;
using System.IO;
using System.Diagnostics;
using System.Reflection;

namespace nft.test.test
{
    class SomeTest
    {
       
        [TestEntry]
        static private bool TestStackFrame() {
            for (int i = 1; i < 4; i++) {
                DumpStack(i);
            }
            return true;
        }

        static private void DumpStack(int skip) {
            Debug.WriteLine("####Dump StackFrame of "+skip+" ###");
            StackFrame callerFrame = new StackFrame(skip);
            MethodBase callerMethod = callerFrame.GetMethod();
            Type callerType = callerMethod.ReflectedType;
            Debug.WriteLine("FullName=" + callerType.FullName);
            Debug.WriteLine("Name=" + callerType.Name);
            Debug.WriteLine("Namespace=" + callerType.Namespace);
            Debug.WriteLine("BaseType=" + callerType.BaseType.FullName);
            Debug.WriteLine("ReflectedType=" + callerType.ReflectedType);
        }

        [TestEntry]
        static private bool TestConverter() {
            object o;
            o = Convert.ChangeType("123", typeof(long));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            o = Convert.ChangeType(456, typeof(string));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            o = Convert.ChangeType("10.82", typeof(float));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            o = Convert.ChangeType("5/2", typeof(DateTime));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            return true;
        }

        [TestEntry(new object[]{@"C:\test\testsub"})]
        [TestEntry(new object[] { "file://c:/test/testsub" })]
        [TestEntry(new object[] { "http://test.com/test/testsub2" })]
        static private string TestUri(string path) {
            Uri u = new Uri(path);
            Debug.WriteLine("abPath="+u.AbsolutePath);
            string localpath = u.LocalPath;
            Debug.WriteLine(localpath);
            return Path.GetFileName(localpath);
        }

        [TestEntry(new object[] { @"C:\test\testsub.xml" })]
        [TestEntry(new object[] { "file://c:/test/testsub" })]
        [TestEntry(new object[] { "http://test.com/test/testsub2.xml" })]
        static private string TestPath(string path) {
            try {
                Debug.WriteLine("FullPath=" + Path.GetFullPath(path));
            } catch (Exception e) {
                Debug.WriteLine(e.Message);
            }
            Debug.WriteLine("DirectoryName=" + Path.GetDirectoryName(path));
            Debug.WriteLine("PathRoot=" + Path.GetPathRoot(path));
            Debug.WriteLine("FileName=" + Path.GetFileName(path));
            Debug.WriteLine("Extension=" + Path.GetExtension(path));
            return Path.GetFileName(Path.GetDirectoryName(path) + "");
        }

    }


}
