﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.IO;
using nft.framework;
using nft.util;
using System.Diagnostics;

namespace nft.test
{
    public partial class ProgressForm : Form
    {
        public ProgressForm() {
            InitializeComponent();
        }

        private Assembly[] asm_array;
        public Assembly[] Assemblies {
            get { return asm_array; }
            set {
                if (value == null) {
                    asm_array = new Assembly[0];
                } else {
                    asm_array = value;
                }
            }
        }

        protected ProgressMonitor monitor; 
        protected override void OnShown(EventArgs e) {
            base.OnShown(e);
            Process();
            Close();
        }

        protected TestLauncher Launcher {
            get {return Owner as TestLauncher; }
        }

        protected void Process() {
            monitor = new ProgressMonitor(1, OnProgress);
            foreach (Assembly asm in Assemblies) {
                progressBar.Value = 0;
                Text = String.Format("Loading {0}", Path.GetFileName(asm.CodeBase));
                monitor.Attach(1,TestUtil.ProgressMonitor);
                foreach (TestInfo info in TestUtil.EnumTestEntries(asm)) {
                    Debug.WriteLine("find test entry:"+info.TestAttribute.Caption);
                    Launcher.AddTestEntry(info);
                }
                monitor.Detach(TestUtil.ProgressMonitor);
            }            
        }

        public void OnProgress(int level, int percentage, string msg) {
            progressBar.Value = percentage;
            labelInfo.Text = msg;
            Update();
        }


    }
}
