#pragma once

/*
	v[ñASYɂ`̎ 8bit
	
	http://www2.starcat.ne.jp/~fussy/algo/algo1-1.htm
	http://en.wikipedia.org/wiki/Bresenham%27s_line_algorithm

*/

#include <cmath>
#include <algorithm>
#include "buffer2d.h"
#include "arrayutil.h"

#include "ILineDrawer.h"
#include "common.h"

namespace gl
{

template <typename NumericT>
class LineDrawer8_Bresenham : public IBufferLineDrawer<NumericT, uint8_t>
{
private:
	Buffer2D<uint8_t>*	pBuff_;
	
	inline
	void blend(
		uint8_t* p,
		uint8_t v
		)
	{
		uint8_t old = *p;
		if (old != 0xff) {
			uint16_t nv = old + v;
			*p = (nv >= 255) ? 255 : nv;
		}
	}
	
	__forceinline
	void drawVerticalLine(uint8_t intensity, NumericT height, NumericT x, NumericT y1, NumericT y2)
	{
		NumericT ys = min(y1, y2);
		uint8_t* ptr = pBuff_->GetPixelPtr(halfAdjust(x), halfAdjust(ys));
		const int lineOffset = pBuff_->GetLineOffset();
		const size_t dy = ToInt(height);
		for (size_t y=0; y<dy; ++y) {
			blend(ptr, intensity);
			OffsetPtr(ptr, lineOffset);
		}
	}
	

	__forceinline
	void drawLine(uint8_t intensity, NumericT width, NumericT height, NumericT x1, NumericT y1, NumericT x2, NumericT y2)
	{
		int dx = width;
		int dy = height;
		int sx = (x1 < x2) ? 1 : -1;
		int sy = (y1 < y2) ? 1 : -1;
		uint8_t* ptr = pBuff_->GetPixelPtr(halfAdjust(x1), halfAdjust(y1));
		sy *= pBuff_->GetLineOffset();
		int dx2 = dx * 2;
		int dy2 = dy * 2;
		int E;

		if (height <= width) {
			// X1ȉ̏ꍇ
			E = -dx;
			for (size_t i=0; i<=dx; ++i) {
				blend(ptr, intensity);
				ptr += sx;
				E += dy2;
				if (0 <= E) {
					OffsetPtr(ptr, sy);
					E -= dx2;
				}
			}
		}else {
			// X1傫ꍇ
			E = -dy;
			for (size_t i=0; i<=dy; ++i) {
				blend(ptr, intensity);
				OffsetPtr(ptr, sy);
				E += dx2;
				if (0 <= E) {
					ptr += sx;
					E -= dy2;
				}
			}
		}
	}
	
public:
	LineDrawer8_Bresenham()
		:
		pBuff_(0)
	{
	}
	
	virtual
	void SetBuffer(Buffer2D<uint8_t>* pBuff) {
		pBuff_ = pBuff;
	}

	virtual
	void DrawVerticalLine(uint8_t intensity, NumericT x, NumericT y1, NumericT y2)
	{
		drawVerticalLine(intensity, abs(y2 - y1), x, y1, y2);
	}
	
	virtual
	void DrawLine(
		uint8_t intensity,
		NumericT x1, NumericT y1,
		NumericT x2, NumericT y2
	) {
		NumericT width = abs(x2 - x1);
		NumericT height = abs(y2 - y1);
		if (width + height == NumericT(0))
			return;
		if ((int)(x2+NumericT(0.5))-((int)(x1+NumericT(0.5))) == 0) {
			drawVerticalLine(intensity, height, x1, y1, y2);
		}else {
			drawLine(intensity, width, height, x1, y1, x2, y2);
		}

		
	}

};

} // namespace gl

