#ifndef THSCHMANAGER_H
#define THSCHMANAGER_H

#include <QThread>
#include <QQueue>
#include <QStringList>

#include "PlayMusicThread.h"

typedef struct StEventData {
    int id; // Event ID
    QString param; // param data
} EventData;

class ThSchManager : public QThread
{
    Q_OBJECT
public:
    explicit ThSchManager(QObject *parent = 0);
    ~ThSchManager();
    void stop();

    void sendEvent_Start();
    void sendEvent_Stop();
    void setThreadPtrPlayMusic(PlayMusicThread *th);
    void setChimeFilepath(QString filepath);
    void setSchTimeList(QStringList list);
    void setHolidaysList(QStringList list);
    void setExcludeSS(bool flag);
    void setExcludeHolidays(bool flag);

signals:
    void sig_notify_nexttime(QString nexttime);

public slots:

protected:
    void run();

private:
    QMutex mutex;
    volatile bool stopped;

    // Event ID
    enum {
        Ev_Nop = 0,
        Ev_Start,
        Ev_Stop
    };
    QQueue<EventData> *EvtQue; // EventQueue

    PlayMusicThread *ThPlayMusic;
    QString ChimeFilepath;

    QStringList SchTimeList; // { "9:00", "12:00", 13:00", "17:30" }
    QStringList HolidaysList; // { "01/01", "02/11", "04/29", ...  }

    bool ExcludeSS; // Disable Chime when Saturday, Sunday
    bool ExcludeHolidays; // Disable Chime when Holiday

    int nextSchTimeIndex(QStringList *list); // find next Sch Time
    int isMatchSchTimeVsCurrentTime(const QString *SchTime);
    bool isSaturdayOrSunday();
    bool isHolidays();

};

#endif // THSCHMANAGER_H
