#include "thschmanager.h"

#include <QStringList>
#include <QDateTime>
#include <QMutexLocker>

#include <QDebug>

ThSchManager::ThSchManager(QObject *parent) :
    QThread(parent)
{
    stopped = false;

    EvtQue = new QQueue<EventData>();
}

ThSchManager::~ThSchManager()
{
    delete EvtQue;
}

void ThSchManager::stop()
{
    QMutexLocker locker(&mutex);
    stopped = true;
}

void ThSchManager::run()
{
    bool EventEmpty;
    EventData event;
    int event_id;
    int status = 0; // 0 = idle, 1 = exec
    int index;
    QString nexttime;

    forever {
        {
            QMutexLocker locker(&mutex);
            if (stopped) {
                stopped = false;
                break;
            } else {
                if (EventEmpty = EvtQue->isEmpty()) {
                    ;
                } else{
                    event = EvtQue->dequeue();
                }
            }
        }
        if (EventEmpty) {
            if (status == 1) { // EXEC (supervise sch time)
                QMutexLocker locker(&mutex);
                // Is Saturday and Sunday
                if ((ExcludeSS && isSaturdayOrSunday()) || (ExcludeHolidays && isHolidays())) {
                    ; // skip
                } else {
                    // Time Check
                    if (isMatchSchTimeVsCurrentTime(&nexttime)) {
                        // qDebug() << "### Time Match!";
                        // Chime Start
                        ThPlayMusic->PlayMusic(ChimeFilepath);

                        // next
                        if ((index + 1) < SchTimeList.count()) {
                            index++;
                        } else {
                            index = 0;
                        }
                        nexttime = SchTimeList.at(index);
                        emit sig_notify_nexttime(nexttime);
                        // qDebug() << "### next time : " << nexttime;
                    }
                }
            }
            sleep(1);
        } else {
                //            event = EvtQue->dequeue();
                event_id = event.id;
                switch(event_id) {
                case Ev_Start:
                    if (status == 0) { // idle
                        QMutexLocker locker(&mutex);
                        // Start;
                        // qDebug() << "### Start!";
                        index = nextSchTimeIndex(&SchTimeList);
                        nexttime = SchTimeList.at(index);
                        emit sig_notify_nexttime(nexttime);
                        // qDebug() << "### next time : " << nexttime;
                        status = 1; // goto EXEC
                    }
                    break;
                case Ev_Stop:
                    if (status == 1) {
                        QMutexLocker locker(&mutex);
                        // Stop;
                        emit sig_notify_nexttime("idle...");
                        // qDebug() << "### Stop!";
                        status = 0; // goto IDLE
                    }
                    break;
                default:
                    break;
                }
        } // if(EventEmpty)
    } // forever
}

void ThSchManager::sendEvent_Start()
{
    EventData evt;

    evt.id = Ev_Start;
    QMutexLocker locker(&mutex);
    EvtQue->enqueue(evt);
}

void ThSchManager::sendEvent_Stop()
{
    EventData evt;

    evt.id = Ev_Stop;
    QMutexLocker locker(&mutex);
    EvtQue->enqueue(evt);
}

void ThSchManager::setThreadPtrPlayMusic(PlayMusicThread *th)
{
    ThPlayMusic = th;
}

void ThSchManager::setChimeFilepath(QString filepath)
{
    ChimeFilepath = filepath;
}

void ThSchManager::setSchTimeList(QStringList list)
{
    if (list.isEmpty()) return;

    QMutexLocker locker(&mutex);
    SchTimeList.clear();
    SchTimeList = list;
    // qDebug() << "ThSchManager::SchTimeList:" << SchTimeList;
}

void ThSchManager::setHolidaysList(QStringList list)
{
    if (list.isEmpty()) return;

    QMutexLocker locker(&mutex);
    HolidaysList.clear();
    HolidaysList = list;
    // qDebug() << "ThSchManager::HolidaysList:" << HolidaysList;
}

void ThSchManager::setExcludeSS(bool flag)
{
    QMutexLocker locker(&mutex);
    ExcludeSS = flag;
}

void ThSchManager::setExcludeHolidays(bool flag)
{
    QMutexLocker locker(&mutex);
    ExcludeHolidays = flag;
}

// private
// find next Sch Time
int ThSchManager::nextSchTimeIndex(QStringList *list)
{
    int ret = 0;

    if (list->isEmpty()) return ret;

    QString now = QTime::currentTime().toString("hh:mm");
    // list is sorted.
    for (int i = 0; i < list->count(); i++) {
        if (list->at(i).compare(now) > 0) {
            ret = i;
            break;
        }
    }

    return ret;
}

// SchTime is "hh:mm"
int ThSchManager::isMatchSchTimeVsCurrentTime(const QString *SchTime)
{
    QString now = QTime::currentTime().toString("hh:mm");
    if (SchTime->compare(now) == 0)
        return 1;
    else
        return 0;
}


// today is Saturday, Sunday
bool ThSchManager::isSaturdayOrSunday()
{
    int dow = QDate::currentDate().dayOfWeek();
    return (dow == 6 || dow == 7);
}

// today is holiday?
bool ThSchManager::isHolidays()
{
    bool ret = false;

    int mon, day;
    QDate today;
    today = QDate::currentDate();
    for (int i = 0; i < HolidaysList.count(); i++) {
        QStringList mandd = HolidaysList.at(i).split("/");
        mon = mandd.at(0).toInt();
        day = mandd.at(1).toInt();
        if ((today.month() == mon) && (today.day() == day)) {
            ret = true;
            break;
        }
    }
    return ret;
}


