#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#include <QGraphicsView>

#include <qrencode.h>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    
private slots:
    void on_btnStart_clicked();

    void on_lineEdit_textChanged(const QString &arg1);

    void on_actionExit_triggered();

    void on_actionSave_triggered();

    void on_actionToClibboard_triggered();

    void on_actionAbout_triggered();

    void on_actionAbout_Qt_triggered();


private:
    Ui::MainWindow *ui;

    QImage *image;						// 表示画像を保存しておく場所
    QGraphicsScene scene;				// QGraphicsView 上に表示させるための準備

    QRcode *encode(const unsigned char *intext, int length);
    QPixmap encodeTextToPixmap( QString text, int size, int margin );

    //    int qrdata_expand(unsigned char *qrcode_data, int qrcode_width, int margin, int size, unsigned char* img_data);
};

#endif // MAINWINDOW_H
