package org.infodb.wax.server;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.infodb.wax.core.HTMLBuilder;
import org.infodb.wax.core.HeaderMenu;
import org.infodb.wax.core.WikiProcessor;
import org.infodb.wax.core.WikiWriter;
import org.infodb.wax.core.db.ContentResolver;
import org.xml.sax.ContentHandler;

public class WikiResolver implements ContentResolver {
    private HttpServletResponse resp;
    private String target;
    private String title;
    private WikiProcessor processor;
    
    private List<HeaderMenu> menuList;
    
    private HTMLBuilder builder;
    
    @Inject
    public WikiResolver(HttpServletResponse resp, String target, String title, WikiProcessor processor, List<HeaderMenu> list) {
        this.resp = resp;
        this.target = target;
        this.title = title;
        this.processor = processor;
        this.menuList = list;
    }
    @Override
    public void setContentType(String contentType) {
        resp.setContentType("text/html; charset=\"UTF-8\"");
        
    }
    @Override
    public ContentHandler getContentHandler() throws IOException {
        if(builder == null) {
            builder = new HTMLBuilder(resp.getWriter(), target, title, menuList);
        }
        return new WikiWriter(processor, builder); 
    }
    public void end() throws IOException {
        builder.end();
    }
}
