/*
 * Copyright (C) 2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaxMain {
    private static final Logger log = LoggerFactory.getLogger(WaxMain.class);
    private static Server server;
    
    public static void main(String[] args) {
        try {
            WaxEnv env = new WaxEnv("./src/main");   // TODO:引数などで最終調整をする。
            
            Handler handler = new Handler();
            handler.init(env);
            
            StopMonitor monitor = new StopMonitor(env.getStopPort());
            monitor.start();
            
            server = new Server();
            server.setConnectors(initConnector(env));
            server.setHandler(handler);
            
            server.setStopAtShutdown(true);
            server.start();
            server.join();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }
    private static Connector[] initConnector(WaxEnv env) {
//        int port = 8080;
//        if(value != null && value.equals("AJP13")) {
//            Ajp13SocketConnector ajp13 = new Ajp13SocketConnector();
//            ajp13.setPort(port);
//            ajp13.setHost("127.0.0.1");
//            
//            return new Connector[] {ajp13};
//        } else {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(env.getPort());
            // TODO:この辺りのプロパティはどう設定するか検討する。
            connector.setMaxIdleTime(30000);
            connector.setRequestHeaderSize(8192);
            
            return new Connector[] {connector};
//        }
    }
    private static class StopMonitor extends Thread {
        private ServerSocket socket;
        
        public StopMonitor(int port) throws IOException {
            setDaemon(true);
            setName("stopMonitor");
            socket = new ServerSocket(port);
        }
        @Override
        public void run() {
            Socket accept;
            try {
                accept = socket.accept();
                // TODO:安全のためにローカルからのアクセスのみ許可するとか。
                BufferedReader reader = new BufferedReader(new InputStreamReader(accept.getInputStream()));
                reader.readLine();

                log.info("stop server...");
                server.stop();
                accept.close();
                socket.close();
            }
            catch(Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }
}
