package org.infodb.wax.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.infodb.wax.core.ActionParams;

public class ActionParamsImpl implements ActionParams {
    private HttpServletRequest req;
    private HttpServletResponse resp;
    private String target;
    
    private boolean outputContent;

    public ActionParamsImpl(HttpServletRequest req, HttpServletResponse resp, String target) {
        this.req = req;
        this.resp = resp;
        this.target = target;
        
        outputContent = false;
    }
    @Override
    public String getMethod() {
        return req.getMethod();
    }
    @Override
    public String getTarget() {
        return target;
    }
    @Override
    public String getParameter(String name) {
        return req.getParameter(name);
    }
    @Override
    public String getContentType() {
        return req.getContentType();
    }
    @Override
    public InputStream getInputStream() throws IOException {
        return req.getInputStream();
    }
    @Override
    public void setOutputContentType(String contentType) {
        resp.setContentType(contentType);
        outputContent = true;
    }
    @Override
    public Writer getWriter() throws IOException {
        if(outputContent == false) {
            resp.setContentType("text/html; charset=\"UTF-8\"");
        }
        return resp.getWriter();
    }
    @Override
    public OutputStream getOutputStream() throws IOException {
        return resp.getOutputStream();
    }
    @Override
    public void redirect(String url) throws IOException {
        resp.sendRedirect(url);
    }

}
