/*
 * Copyright (C) 2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.plugins;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.infodb.wax.core.Action;
import org.infodb.wax.core.ActionParams;
import org.infodb.wax.core.HTMLBuilder;
import org.infodb.wax.core.HeaderMenu;
import org.infodb.wax.core.Plugin;
import org.infodb.wax.core.SystemEnv;
import org.infodb.wax.core.View;
import org.infodb.wax.core.WikiBridge;
import org.infodb.wax.core.db.XmlStorage;
import org.infodb.wax.core.html.AbstractBody;
import org.infodb.wax.core.html.Attr;
import org.infodb.wax.core.html.AttrFORM;
import org.infodb.wax.core.html.FORM;

public class PagePlugin implements Plugin {
    private String caption;
    private XmlStorage storage;
    
    @Override
    public void startup(SystemEnv env) throws IOException, SQLException {
        ResourceBundle res = ResourceBundle.getBundle(getClass().getCanonicalName(), env.getLocale());
        
        caption = res.getString("sysmenu.edit");
        env.addMenu(new HeaderMenu() {
            @Override
            public int getOrderNo() {
                return 20;
            }
            @Override
            public void build(String target, AbstractBody body) throws IOException {
                StringBuilder sb = new StringBuilder("/ext/page.form");
                sb.append(target);
                body.a(Attr.href(sb.toString())).text(caption).end();
            }
        });
        storage = env.getStorage("default");
    }
    @Override
    public void exit() {
    }
    @View("sample")
    public void sample(WikiBridge bridge, AbstractBody body) throws IOException {
        body.text("this is view sample plugin");
    }
    @Action("page.form")
    public void pageForm(ActionParams params) throws IOException {
        HTMLBuilder builder = new HTMLBuilder(params.getWriter(), params.getTarget(), params.getTarget(), null);
        
        AbstractBody body = builder.next(null);
        
        // TODO:新規ページはこのフォームで良いのか？
        // TODO:現在のページの内容を取得する
        FORM form = body.form(AttrFORM.action("/ext/page.store", params.getTarget()));
        form.textArea("text", "");
        form.inputSubmit("entry", "更新");
        form.end();
        
        builder.end();
    }
    @Action("page.store")
    public void storePage(ActionParams params) throws IOException {
        System.out.println("storePage");
        
        System.out.println(params.getParameter("text"));
        
        params.redirect(params.getTarget());
    }
}
