/*
 * Copyright (C) 2011-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.html;

import java.io.IOException;
import java.io.Writer;

public class Attr {
    private String name;
    private String value;
    
    public Attr(String name, String value) {
        this.name = name;
        this.value = value;
    }
    public String getName() {
        return name;
    }
    public String getValue() {
        return value;
    }
    
    public static void output(Writer writer, Attr... attr) throws IOException {
        if(attr.length > 0) {
            for(Attr a : attr) {
                writer.write(" ");
                writer.write(a.getName());
                if(a.getValue() != null) {
                    writer.write("=\"");
                    writer.write(a.getValue());
                    writer.write("\"");
                }
            }
        }
    }
    
    public static Attr clazz(String val) {
        return new Attr("class", val);
    }
    
    
    public static Attr charset(String val) {
        return new Attr("charset", val);
    }
    public static Attr rel(String val) {
        return new Attr("rel", val);
    }
    public static Attr href(String val) {
        return new Attr("href", val);
    }
    
    public static Attr reserved() {
        return new Attr("reserved", null);
    }
    public static Attr start(int i) {
        return new Attr("start", Integer.toString(i));
    }
    public static Attr type(String val) {
        return new Attr("type", val);
    }
    
    public static Attr alt(String val) {
        return new Attr("alt", val);
    }
    public static Attr target(String val) {
        return new Attr("target", val);
    }
    
    public static Attr colspan(int span) {
        return new Attr("colspan", Integer.toString(span));
    }
    public static Attr rowspan(int span) {
        return new Attr("rowspan", Integer.toString(span));
    }
    
    public static Attr src(String src) {
        return new Attr("src", src);
    }
} 
