/*
 * Copyright (C) 2011 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import javax.inject.Inject;

public class SQLDDL {
    public static final int CHAR = 0;
    public static final int VARCHAR = 1;
    public static final int NUMERIC = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;
    public static final int DATETIME = 5;
    public static final int CLOB = 6;
    public static final int BLOB = 7;
    public static final int XML = 8;
    public static final int DROP_OPTION = 9;
    public static final int NULLABLE = 10;

    private String[] defs;
    private StringBuilder sb;
    private boolean first;

    @Inject
    public SQLDDL(String[] defs) {
        this.defs = defs;
        sb = new StringBuilder();
    }
    public SQLDDL dropTable(String tableName) {
        sb.append("DROP TABLE ")
          .append(tableName);
        if(defs[DROP_OPTION] != null) {
            sb.append(" ").append(defs[DROP_OPTION]).append(" ");
        }
        return this;
    }

    public SQLDDL createTable(String tableName) {
        sb.append("CREATE TABLE ")
          .append(tableName)
          .append(" (");
        first = true;
        return this;
    }
    public SQLDDL column(String colName, int type) {
        if(first == false) {
            sb.append(",");
        }
        sb.append(colName)
          .append(" ")
          .append(defs[type]);
        first = false;
        return this;
    }
    public SQLDDL column(String colName, int type, int size) {
        if(first == false) {
            sb.append(",");
        }
        sb.append(colName)
          .append(" ")
          .append(defs[type])
          .append("(")
          .append(size)
          .append(")");
        first = false;
        return this;
    }
    public SQLDDL column(String colName, int type, int size, int decimal) {
        if(first == false) {
            sb.append(",");
        }
        sb.append(colName)
          .append(" ")
          .append(defs[type])
          .append("(")
          .append(size)
          .append(",")
          .append(decimal)
          .append(")");
        first = false;
        return this;
    }
    public SQLDDL notNull() {
        sb.append(" NOT NULL");
        return this;
    }
    public SQLDDL nullable() {
        if(defs[NULLABLE] != null) {
            sb.append(defs[NULLABLE]);
        }
        return this;
    }
    public SQLDDL isNull(boolean flag) {
        if(flag == true) {
            return nullable();
        }
        return notNull();
    }
    /**
     * 単一primary keyを指定する場合に使用するメソッド、カラム定義の際に指定する。
     * @return 
     */
    public SQLDDL primaryKey() {
        sb.append(" PRIMARY KEY");
        return this;
    }
    /**
     * 複数のprimary keyが存在する場合に使用するメソッド。文の最後に使用する。
     * @param args
     * @return 
     */
    public SQLDDL PK(String ...args) {
        sb.append(",PRIMARY KEY(");
        boolean f = true;
        for (String string : args) {
            if(f == false) {
                sb.append(",");
            }
            sb.append(string);
            f = false;
        }
        sb.append(")");
        return this;
    }
    public void end() {
        sb.append(")");
    }
    @Override
    public String toString() {
        return sb.toString();
    }
}
