/*
 * Copyright (C) 2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.xml.sax.SAXException;

public class BindClobResolver implements BindResolver {
    @Override
    public void bind(Connection conn, PreparedStatement stmt, XmlStore store, int index) throws SQLException {
        Clob clob = conn.createClob();
        try (Writer writer = clob.setCharacterStream(1)) {
            store.setWriter(writer);
            store.execute();
            stmt.setClob(index, clob);
        }
        catch(IOException | SAXException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }
}
