/* ControllerView */

#import <Cocoa/Cocoa.h>
#import "ControllerSkin.h"

@interface ControllerView : NSView
{
    NSImage* _bgImage;
    
    NSImage* _displayItem[DISPLAY_ITEM_NUM];
    NSPoint _displayItemOrigin[DISPLAY_ITEM_NUM];
    BOOL _displayItemDisplay[DISPLAY_ITEM_NUM];
    
    NSArray* _displayHtml[DISPLAY_TEXT_NUM];
    NSRect _displayTextRect[DISPLAY_TEXT_NUM];
    NSAttributedString* _displayText[DISPLAY_TEXT_NUM];
}

-(void)setImage:(NSImage*)img;
-(void)setDisplayImage:(NSImage*)img andOrigin:(NSPoint)p forTag:(int)tag;
-(void)setDisplayHtml:(NSArray*)ary andRect:(NSRect)r forTag:(int)tag;

-(void)setDisplayItemDisplay:(BOOL)b forTag:(int)tag;
-(void)setAllDisplayItem:(BOOL)b;
-(void)setDisplayText:(NSString*)str forTag:(int)tag;

@end
