from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtNetwork import *
import csv

class IpcOutputServer(QObject):
    def __init__(self, parent=None):
        self.srv = QLocalServer(parent)
        self.activeSockets = []
        self.srv.newConnection.connect(self.addSocket)
    def sendAll(self, str):
        for sock in self.activeSockets:
            if type(sock) == QLocalSocket:
                if sock.isWritable():
                    sock.write(QString(str).toUtf8())
                    sock.flush()
    def addSocket(self):
        sock = self.srv.nextPendingConnection()
        sock.disconnected.connect(lambda: self.activeSockets.remove(sock))
        self.activeSockets.append(sock)

ipcOutputServer = IpcOutputServer(form)
ipcOutputServer.srv.removeServer("twitturnIpcOutputServer")
ipcOutputServer.srv.listen("twitturnIpcOutputServer")

def sendToTheIpcOutPort(message):
    if ipcOutputServer.srv.isListening():
        ipcOutputServer.sendAll(
                message)

form.connect(form, QtCore.SIGNAL("notificated"), sendToTheIpcOutPort)
