from PyQt4.QtCore import *
from PyQt4.QtGui import *
from twitturnTimeLineWidget import *
from extractionConfigDialog import *
from extractionTabFilter import *

class ExtractionTimeLineWidget(TwitturnTimeLineWidget):
    def __init__(self, tabId, form, *args):
        self.filter = ExtractionTabFilter( tabId, form, self)
        self.tabId = tabId
        TwitturnTimeLineWidget.__init__(self, *args)
        self.treeWidget.mouseReleaseEvent = self.mouseReleaseEvent

    def mouseReleaseEvent(self, mouseEvent):
        if mouseEvent.button() == Qt.RightButton:
            print self.tabId
            dialog = ExtractionConfigDialog(self.tabId, self)
            dialog.exec_()
            self.loadSettings()

    def loadSettings(self):
        TwitturnTimeLineWidget.loadSettings(self)
        self.filter.loadSettings()

        self.settings.beginGroup("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1))

        self.setTabName(self.settings.value("tabName").toString())

        self.settings.endGroup()

    def setTabName(self, name):
        TwitturnTimeLineWidget.setTabName(self, name)
        self.filter.setTabName(name)
    def tabName(self):
        return self.filter.tabName
    def closeEvent(self, event):
        self.disconnect(self.filter.form, SIGNAL("newPostCame"),
                self.filter.filter)
        self.connect(
                self.treeWidget, 
                QtCore.SIGNAL('currentItemChanged(QTreeWidgetItem*, QTreeWidgetItem*)'),
                self.filter.form.setCurrentPost)
        self.connect(
                self.treeWidget,
                QtCore.SIGNAL('itemDoubleClicked(QTreeWidgetItem *,int)'),
                self.filter.form.putReplyHeader)

        self.settings.beginGroup("plugins/extractionTabs/tabs/"+QString.number(self.tabId+1))

        self.settings.setValue("visible", QVariant(False))

        self.settings.endGroup()
