from PyQt4.QtCore import *
from PyQt4.QtNetwork import *
try:
    from xml.etree import ElementTree
except:
    from elementtree import ElementTree

TwiturnWeb = 'twitturn'
timeoutSec = 30
class TwitturnCore(QHttp):
    def __init__(self, parent=None, user="", password=""):
        QHttp.__init__(self, parent)

        self.url = QUrl()
        self.setHost("twitter.com")
        self.url.setQueryDelimiters("=",";")
        self.parseMode = ''
        self.statuses = []
        self.defaultQueryMethod = "POST"
        self.timer = QTimer(self)
        self.timer.setSingleShot(True)
        self.timer.setInterval(timeoutSec*1000)
        self.connect(self.timer, SIGNAL("timeout()"), self.abort)

        if not user=="":
            self.setUser(user, password)

        self.connect(self, SIGNAL("done(bool)"), self.done)

    def abort(self):
        print "timeout"
        return QHttp.abort(self)

    def done(self, error):
        self.url.clear()
        self.timer.stop()
        if not error and self.lastResponse().statusCode() == 200:
            self.parse()
            self.emit(SIGNAL("parseDone"))

    def setQueryMethod(self, method):
        self.defaultQueryMethod = method
        
    def queryApiLimitStatus(self):
        self.url.setPath('/account/rate_limit_status.xml')
        self.parseMode = 'ApiLimitStatus'
        return self.query()

    def queryFriendsTimeline(self, 
            since_id=None, max_id=None, count=None, page=None):
        self.url.setPath('/statuses/friends_timeline.xml')
        if not since_id==None:
            self.url.addQueryItem("since_id", QString.number(since_id))
        if not max_id==None:
            self.url.addQueryItem("max_id", QString.number(max_id))
        if not count == None:
            self.url.addQueryItem("count", QString.number(count))
        if not page == None:
            self.url.addQueryItem("page", QString.number(page))
        self.parseMode = 'FriendsTimeline'
        print self.url.toString().toAscii()
        return self.query()
    def queryUpdate(self, status, replyTo=None, source=TwiturnWeb):
        self.url.setPath('/statuses/update.xml')
        self.url.addQueryItem("status", status)
        if not replyTo == None:
            self.url.addQueryItem("in_reply_to_status_id", replyTo)
        self.parseMode = 'StatusUpdate'
        self.url.addQueryItem("source", source)
        return self.post()
    def queryFavorite(self, statusId, favo=True):
        if favo:
            self.url.setPath('/favourings/create/' + statusId + '.xml')
        else:
            self.url.setPath('/favourings/destroy/' + statusId + '.xml')
        self.parseMode = 'Favorite'
        return self.post()

    def queryReplies(self, page=None, since=None, since_id=None):
        self.url.setPath('/statuses/replies.xml')
        if not page==None:
            self.url.addQueryItem("page", page)
        if not since==None:
            self.url.addQueryItem("since", since)
        if not since_id==None:
            self.url.addQueryItem("since_id", since_id)
        self.parseMode = 'Replies'
        return self.query()

    def queryDirectMessages(self, page=None, since=None, since_id=None):
        self.url.setPath('/direct_messages.xml')
        if not page==None:
            self.url.addQueryItem("page", page)
        if not since==None:
            self.url.addQueryItem("since", since)
        if not since_id==None:
            self.url.addQueryItem("since_id", since_id)
        self.parseMode = 'DirectMessages'
        return self.get()


    # This method is NOT debugged yet!
    def newDirectMessage(self, user, text): 
        self.url.setPath('/direct_messages/new.xml')
        self.url.addQueryItem('user', user)
        self.url.addQueryItem('text', text)
        self.parseMode = 'newDirectMessage'
        return self.post()

    def query(self):
        if self.defaultQueryMethod == "POST":
            return self.post()
        elif self.defaultQueryMethod == "GET":
            return self.get()

    def get(self):
        self.timer.start()
        return QHttp.get(self, self.url.toString())
    def post(self):
        self.timer.start()
        return QHttp.post(self, self.url.toString(), QByteArray())

    def parse(self):
        if self.parseMode in (
                'FriendsTimeline',
                'Replies'):
            byteArray = self.readAll()
            str = QString(byteArray)
            self.parseAsFriendsTimeline(str)
            self.parseMode == ""
            self.emit(SIGNAL("friendsTimelineUpdated"), self.statuses)
        elif self.parseMode == 'DirectMessages':
            byteArray = self.readAll()
            str = QString(byteArray)
            self.parseAsDirectMessages(str)
            self.parseMode == ""
            self.emit(SIGNAL("friendsTimelineUpdated"), self.statuses)
        elif self.parseMode == 'ApiLimitStatus':
            byteArray = self.readAll()
            str = QString(byteArray)
            self.parseMode == ""
            self.emit(SIGNAL('apiLimitStatusReady'),
                    parseAsApiLimitStatus(str))
        elif self.parseMode == 'StatusUpdate':
            byteArray = self.readAll()
            str = QString(byteArray)
            self.parseAsStatusUpdate(str)
            self.parseMode == ""
            self.emit(SIGNAL("friendsTimelineUpdated"), self.statuses)
        elif self.parseMode == 'newDirectMessage':
            self.emit(SIGNAL("newDirectMessageDone"))
        elif self.parseMode == 'Favorite':
            self.emit(SIGNAL("toggleFavoDone"))

    def parseAsFriendsTimeline(self, str):
        self.statuses = []
        if str == "":
            return 
        try:
            root = ElementTree.fromstring(str.toAscii())
        except:
            print str.toAscii()
            return
        for elm in root.findall("status"):
            timestamp = elm.findtext("created_at")
            statusId = elm.findtext("id")
            status = elm.findtext("text")
            source = elm.findtext("source")
            favorited = elm.findtext("favorited")
            replyToStatusId = elm.findtext("in_reply_to_status_id")
            sub = elm.find("user")
            name = sub.findtext("name")
            nick = sub.findtext("screen_name")
            location = sub.findtext("location")
            icon = sub.findtext("profile_image_url")
            web = sub.findtext("url")
            protected = sub.findtext("protected")
            type = "stat"
            self.statuses.insert(
                    0,
                ( icon, nick, status, timestamp,
                    statusId, name, web, type, replyToStatusId, 
                    boolStrToFavStr(favorited),
                    source, location,
                    boolStrToProtectedStr(protected),
                    ),
                )
    def parseAsDirectMessages(self, str):
        self.statuses = []
        if str == "":
            return 
        try:
            root = ElementTree.fromstring(str.toAscii())
        except:
            print str.toAscii()
            return
        for elm in root.findall("direct_message"):
            timestamp = elm.findtext("created_at")
            statusId = elm.findtext("id")
            status = elm.findtext("text")
            sub = elm.find("sender")
            nick = sub.findtext("screen_name")
            name = sub.findtext("name")
            icon = sub.findtext("profile_image_url")
            web = sub.findtext("url")
            type = "DM"
            self.statuses.insert(
                    0,
                    ( icon, nick, status, timestamp, statusId, name, web, type, ""))


    def parseAsStatusUpdate(self, str):
        self.statuses = []
        if str == "":
            return 
        try:
            root = ElementTree.fromstring(str.toAscii())
        except:
            print str.toAscii()
            return
        elm = root
        timestamp = elm.findtext("created_at")
        statusId = elm.findtext("id")
        status = elm.findtext("text")
        source = elm.findtext("source")
        favorited = elm.findtext("favorited")
        replyToStatusId = elm.findtext("in_reply_to_status_id")
        sub = elm.find("user")
        name = sub.findtext("name")
        nick = sub.findtext("screen_name")
        location = sub.findtext("location")
        icon = sub.findtext("profile_image_url")
        web = sub.findtext("url")
        protected = sub.findtext("protected")
        type = "stat"
        self.statuses.insert(
                0,
                ( icon, nick, status, timestamp,
                    statusId, name, web, type, replyToStatusId, 
                    boolStrToFavStr(favorited),
                    source, location,
                    boolStrToProtectedStr(protected),
                    ),
                )

def boolStrToFavStr(val):
    if val == "true":
        return "F"
    else:
        return ""
def boolStrToProtectedStr(val):
    if val == "true":
        return "P"
    else:
        return ""
def parseAsApiLimitStatus(str):
    if str == "":
        return None
    try:
        root = ElementTree.fromstring(str.toAscii())
    except:
        print str.toAscii()
        return None
    return [
            root.findtext('remaining-hits'),
            root.findtext('hourly-limit'),
            root.findtext('reset-time'),
            root.findtext('reset-time-in-seconds')
            ]
