import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import uic

form_class, base_class = uic.loadUiType(
        os.path.join(
            "plugins","wordSplitter","wordSelector.ui"))
class WordSelector(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)
        self.setupUi(self)

        self.childButtons = []
        self.searchUrls = [
                ('Google', 'http://www.google.com/search?q=%s'),
                ('Wikipedia', 'http://www.google.com/search?btnI=I%27m+Feeling+Lucky&q=site%3Aja.wikipedia.org++%s'),
                ('Twitter Search', 'http://pcod.no-ip.org/yats/search?query=%s'),
                ]
        self.restoreSearchUrls()
        self.setStyleSheet(
"""QToolButton:focus{
    background-color: gray;
}"""
)
    def restoreSearchUrls(self):
        for url in self.searchUrls:
            self.comboBox.addItem(
                    QString(url[0]), 
                    QVariant(QString(url[1])))

    def setWords(self, words):
        hLayout = QHBoxLayout()
        self.mainLayout.addLayout(hLayout)
        for i, word in enumerate(words):
            if i%15 == 0:
                hLayout.addStretch()
                hLayout = QHBoxLayout()
                self.mainLayout.addLayout(hLayout)
            button = QToolButton(self)
            self.childButtons.append(button)
            button.setToolButtonStyle(Qt.ToolButtonTextOnly)
            button.setCheckable(True)
            button.setText(word[1])
            self.connect(button, SIGNAL('toggled(bool)'), 
                    self.toggleAndFocusNextButton)
            hLayout.addWidget(button)
            if i == 0:
                button.setFocus()
        hLayout.addStretch()
        return

    def toggleAndFocusNextButton(self, dummy):
        self.focusNextChild()
        return


    def keyPressEvent(self, keyEvent):
        key =  keyEvent.key()
        if key in ( Qt.Key_L, Qt.Key_J):
            self.focusNextChild()
            return
        if key in ( Qt.Key_H, Qt.Key_K):
            self.focusPreviousChild()
            return
        if key in (Qt.Key_R, Qt.Key_Return, Qt.Key_Enter): 
            self.accept()
            self.close()
            return

        base_class.keyPressEvent(self, keyEvent)

    def accept(self):
        str = QString()
        for button in self.childButtons:
            if button.isChecked():
                str += button.text()
            else:
                str += " "
        print str.toLocal8Bit()
        #url = QString("")
        url = self.comboBox.itemData(
                self.comboBox.currentIndex()).toString()
        url = url.replace('%s', 
                QString(
                    QUrl(str).toEncoded()))
        print url
        QDesktopServices.openUrl(QUrl.fromEncoded(url.toAscii()))
        base_class.accept(self)
