from PyQt4.QtCore import *
from PyQt4.QtGui import *
from plugins.extractionTabs.extractionTabFilter import *
from plugins.extractionTabs.extractionTimeLineWidget import *

def appendExtractionTab(form, tabId, tabName=None):
    print "appendExtractionTab"
    widget = ExtractionTimeLineWidget(tabId, form, form.tabWidget)
    widget.setClosable(True)
    if not tabName == None:
        widget.setTabName(tabName)
    else:
        tabName = widget.tabName()
    form.appendTab(
            widget,
            tabName,
            widget.filter.filter)
    return widget

def restoreExtractionTabs(form):
    settings = QSettings("Twitturn")
    settings.beginGroup("plugins/extractionTabs")
    tabs = settings.beginReadArray("tabs")
    for i in range(tabs):
        settings.setArrayIndex(i)
        if settings.value("visible").toBool():
            appendExtractionTab(form, i)
    settings.endArray()
    settings.endGroup()

def newExtractionTab():
    settings = QSettings("Twitturn")
    settings.beginGroup("plugins/extractionTabs")
    tabs = settings.beginReadArray("tabs")
    i = 0
    for i in range(tabs):
        settings.setArrayIndex(i)
        if not settings.value("visible").toBool():
            break
    settings.endArray()
    settings.endGroup()

    if i < tabs-1:
        tabId = i
        appendExtractionTab(form, tabId)
        settings.setValue("plugins/extractionTabs/tabs/size",
                QVariant(tabs))
    else:
        tabId = tabs
        appendExtractionTab(form, tabId, 
                form.tr("Extraction")+"&"+QString.number(tabId))
        settings.setValue("plugins/extractionTabs/tabs/size",
                QVariant(tabs+1))

    print i,tabs

restoreGUISettingsOriginal = form.restoreGUISettings
def restoreGUISettingsAndExtractionTabs():
    restoreGUISettingsOriginal()
    restoreExtractionTabs(form)

form.restoreGUISettings = restoreGUISettingsAndExtractionTabs
restoreExtractionTabs(form)
form.connect(
        form.tabWidget.actionNewExtractionTab, SIGNAL("triggered()"), 
                newExtractionTab)
