#!/usr/bin/env python
import sys
from PyQt4 import QtCore, QtGui, uic

form_class, base_class = uic.loadUiType("timeLineWidget.ui")
class TwitturnTimeLineWidget(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)
        self.parentTabWidget = args[0]
        self.closable = False

        self.setupUi(self)
        self.treeWidget.setAttribute( 
                QtCore.Qt.WA_InputMethodEnabled, False)

        self.rxReply = QtCore.QRegExp("@([a-zA-Z0-9_]+)")
        self.highlightColorBuffer = None
        self.currentPostColorBuffer = None
        self.highlightingNicks = []

        self.replyToBackgroundBrush = QtGui.QBrush( 
                QtGui.QColor('pink'))
        self.currentPostBackgroundBrush = QtGui.QBrush(
                QtGui.QColor('#89b6d9'))
        self.treeWidget.setStyleSheet('selection-background-color: #b2c3d0')
        self.treeWidget.setStyleSheet('font-size: 14px')

        self.connectActions()

        self.settings = QtCore.QSettings("Twitturn")
        self.loadSettings()

    def clear(self):
        self.treeWidget.clear()
        self.highlightColorBuffer = None
        self.currentPostColorBuffer = None

    def setClosable(self, closable):
        self.closable = closable
    def isClosable(self):
        return self.closable

    def setTabName(self, name):
        tabWidget = self.parentTabWidget
        idx = tabWidget.indexOf(self)
        tabWidget.setTabText(idx, name)
    def tabName(self):
        tabWidget = self.parentTabWidget
        idx = tabWidget.indexOf(self)
        return tabWidget.tabText(idx)

    def setNotify(self, notify):
        tabWidget = self.parentTabWidget
        idx = tabWidget.indexOf(self)
        if notify:
            tabWidget.setTabIcon(idx, QtGui.QIcon("images/new.png"))
        else:
            tabWidget.setTabIcon(idx, QtGui.QIcon())

    def changeThisTab(self):
        tabWidget = self.parentTabWidget
        if not tabWidget.currentWidget() == self:
            tabWidget.setCurrentWidget(self)
        else:
            if self.treeWidget.currentItem() == None:
                self.treeWidget.setCurrentItem(
                    self.treeWidget.topLevelItem(0))
            self.treeWidget.setFocus()

    def connectActions(self):
        self.connect(self.treeWidget, QtCore.SIGNAL('currentItemChanged(QTreeWidgetItem*, QTreeWidgetItem*)'),
                self.setCurrentPost)
        return

    def closeEvent(self, event):
        self.saveSettings()

    def loadSettings(self):
        self.treeWidget.header().restoreState(
                self.settings.value("GUI/treeWidget/header").toByteArray())

    def saveSettings(self):
        pass

    def addPost(self, post, clone=True):
        insertItem = post
        if clone:
            insertItem = post.clone()

        itemCount = self.treeWidget.topLevelItemCount()
        if itemCount == 0:
            self.insertTopLevelItem(0, insertItem)
            return True

        for i in range(itemCount):
            item = self.treeWidget.topLevelItem(i)
            if 1000 < i:
                return False
            if post.text(4) == item.text(4):
                return False
            if post.text(3) > item.text(3) :
                self.insertTopLevelItem(i, insertItem)
                if self.settings.value(
                        "log/limitTimeLineLogCount").toBool():
                    self.limitItems()
                return True
        return False

    def insertTopLevelItem(self, index, item):
        self.treeWidget.insertTopLevelItem(index, item)
        self.hilightItemIfNecessary(item)
        return

    def limitItems(self):
        limitCount = self.settings.value( "log/limitCount").toInt()[0]
        removeCount =  self.treeWidget.topLevelItemCount() - limitCount
        if 0 < removeCount :
            for i in range(removeCount):
                self.treeWidget.takeTopLevelItem(
                        self.treeWidget.topLevelItemCount()-1)
        return

    def setCurrentPost(self, current, previous):
        if current == previous:
            return
        if current == None:
            current = previous
        nicks = [] 
        nicks = self.pickupNicks(current.text(2))
        nicks.append(current.text(1))

        self.clearHighlighting()
        self.highlightNics(nicks)
        self.highlightCurrentPost()
        self.highlightReplyToPost(current.text(8))

        self.emit(QtCore.SIGNAL('currentItemChanged(QTreeWidgetItem*, QTreeWidgetItem*)'), current, previous)

    def pickupNicks(self, str):
        list = []
        pos = 0
        while True:
            pos = self.rxReply.indexIn(str, pos)
            if pos == -1:
                break;
            list.append(self.rxReply.cap(1))
            pos += self.rxReply.matchedLength()
        return list

    def highlightNics(self, nicks):
        highlitCheckRange = 100
        self.highlightingNicks = nicks

        
        currentItem = self.treeWidget.currentItem()
        idx = self.treeWidget.indexOfTopLevelItem(currentItem)

        for i in range(
                max(idx-highlitCheckRange, 0),
                min(
                    idx+highlitCheckRange, 
                    self.treeWidget.topLevelItemCount())):
            item = self.treeWidget.topLevelItem(i)
            self.hilightItemIfNecessary(item)

    def hilightItemIfNecessary(self, item):
        for nick in self.highlightingNicks:
            if item.text(1) == nick:
                item.setSelected(True)
                break
    def clearHighlighting(self):
        self.treeWidget.clearSelection()
        if not self.highlightColorBuffer == None:
            item = self.highlightColorBuffer
            for col in range(self.treeWidget.columnCount()):
                item[0].setBackground(col, item[1])
            self.highlightColorBuffer = None
        if not self.currentPostColorBuffer == None:
            item = self.currentPostColorBuffer
            for col in range(self.treeWidget.columnCount()):
                item[0].setBackground(col, item[1])
            self.currentPostColorBuffer = None

    def highlightCurrentPost(self):
        item = self.treeWidget.currentItem()
        self.currentPostColorBuffer = (item, item.background(0))
        item.setSelected(False)
        for col in range(self.treeWidget.columnCount()):
            item.setBackground(col, self.currentPostBackgroundBrush)


    def highlightReplyToPost(self, replyToStatusId):
        if replyToStatusId == "":
            return
        highlitCheckRange = 100

        currentItem = self.treeWidget.currentItem()
        idx = self.treeWidget.indexOfTopLevelItem(currentItem)

        for i in range(
                max(idx-highlitCheckRange, 0),
                min(
                    idx+highlitCheckRange, 
                    self.treeWidget.topLevelItemCount())):
            item = self.treeWidget.topLevelItem(i)
            if item.text(4) == replyToStatusId:
                self.highlightColorBuffer = ( item, item.background(0))
                item.setSelected(False)
                for col in range(self.treeWidget.columnCount()):
                    item.setBackground(col, self.replyToBackgroundBrush)
                break
    def swapHighlighting(self):
        if not self.highlightColorBuffer == None:
            item = self.highlightColorBuffer
            for col in range(self.treeWidget.columnCount()):
                item[0].setBackground(col, item[1])
        return
    def unswapHighlighting(self):
        if not self.highlightColorBuffer == None:
            item = self.highlightColorBuffer
            for col in range(self.treeWidget.columnCount()):
                item[0].setBackground(col, self.replyToBackgroundBrush)


if __name__=="__main__":
    app = QtGui.QApplication(sys.argv)
    form = TwitturnTimeLineWidget()
    form.show()
    app.exec_()
