from PyQt4.QtCore import *
from PyQt4.QtNetwork import *
from PyQt4.QtXml import *
try:
    from xml.etree import ElementTree
except:
    from elementtree import ElementTree

TwiturnWeb = '&lt;a href="http://sourceforge.jp/projects/twitturn"&gt;Twitturn&lt;a&gt;'
class TwitturnCore(QHttp):
    def __init__(self, parent=None, user="", password=""):
        QHttp.__init__(self, parent)

        self.url = QUrl()
        self.setHost("twitter.com")
        self.url.setQueryDelimiters("=",";")
        self.parseMode = ''
        self.statuses = []
        self.defaultQueryMethod = "POST"

        if not user=="":
            self.setUser(user, password)

        self.connect(self, SIGNAL("done(bool)"), self.done)

    def done(self, error):
        self.url.clear()
        if not error and self.lastResponse().statusCode() == 200:
            self.parse()
            self.emit(SIGNAL("parseDone"))

    def setQueryMethod(self, method):
        self.defaultQueryMethod = method
        
    def queryFriendsTimeline(self, 
            friendId=None, count=None, since=None, page=None):
        self.url.setPath('/statuses/friends_timeline.xml')
        if not friendId==None:
            self.url.addQueryItem("id",friendId)
        if not count == None:
            self.url.addQueryItem("count", count)
        if not since == None:
            self.url.addQueryItem("since", 
                    str(QUrl.toPercentEncoding(since)))
        if not page == None:
            self.url.addQueryItem("page", page)
        self.parseMode = 'FriendsTimeline'
        return self.query()
    def queryUpdate(self, status, source=TwiturnWeb):
        self.url.setPath('/statuses/update.xml')
        self.url.addQueryItem("status", status)
        self.url.addQueryItem("source", source)
        self.parseMode = 'StatusUpdate'
        return self.post()
    def queryFavorite(self, statusId, favo=True):
        if favo:
            self.url.setPath('/favourings/create/' + statusId + '.xml')
        else:
            self.url.setPath('/favourings/destroy/' + statusId + '.xml')
        self.parseMode = 'Favorite'
        return self.query()

    def queryReplies(self, page=None, since=None, since_id=None):
        self.url.setPath('/statuses/replies.xml')
        if not page==None:
            self.url.addQueryItem("page", page)
        if not since==None:
            self.url.addQueryItem("since", since)
        if not since_id==None:
            self.url.addQueryItem("since_id", since_id)
        self.parseMode = 'Replies'
        return self.query()

    def queryDirectMessages(self, page=None, since=None, since_id=None):
        self.url.setPath('/direct_messages.xml')
        if not page==None:
            self.url.addQueryItem("page", page)
        if not since==None:
            self.url.addQueryItem("since", since)
        if not since_id==None:
            self.url.addQueryItem("since_id", since_id)
        self.parseMode = 'DirectMessages'
        return self.get()


    # This method is NOT debugged yet!
    def newDirectMessage(self, user, text): 
        self.url.setPath('/direct_messages/new.xml')
        self.url.addQueryItem('user', user)
        self.url.addQueryItem('text', text)
        self.parseMode = 'newDirectMessage'
        return self.post()

    def query(self):
        if self.defaultQueryMethod == "POST":
            return self.post()
        elif self.defaultQueryMethod == "GET":
            return self.get()

    def get(self):
        return QHttp.get(self, self.url.toString())
    def post(self):
        return QHttp.post(self, self.url.toString(), QByteArray())

    def parse(self):
        if self.parseMode in (
                'FriendsTimeline',
                'Replies'):
            byteArray = self.readAll()
            str = QString(byteArray)
            self.parseAsFriendsTimeline(str)
            self.parseMode == ""
            self.emit(SIGNAL("friendsTimelineUpdated"), self.statuses)
        elif self.parseMode == 'DirectMessages':
            byteArray = self.readAll()
            str = QString(byteArray)
            self.parseAsDirectMessages(str)
            self.parseMode == ""
            self.emit(SIGNAL("friendsTimelineUpdated"), self.statuses)
        elif self.parseMode == 'StatusUpdate':
            self.emit(SIGNAL("statusUpdated"))
        elif self.parseMode == 'newDirectMessage':
            self.emit(SIGNAL("newDirectMessageDone"))

    def parseAsFriendsTimeline(self, str):
        self.statuses = []
        if str == "":
            return 
        try:
            root = ElementTree.fromstring(str.toAscii())
        except:
            print str.toAscii()
            return
        for elm in root.findall("status"):
            timestamp = elm.findtext("created_at")
            statusId = elm.findtext("id")
            status = elm.findtext("text")
            sub = elm.find("user")
            nick = sub.findtext("screen_name")
            name = sub.findtext("name")
            icon = sub.findtext("profile_image_url")
            web = sub.findtext("url")
            type = "stat"
            self.statuses.insert(
                    0,
                    ( icon, nick, status, timestamp, statusId, name, web, type))
    def parseAsDirectMessages(self, str):
        self.statuses = []
        if str == "":
            return 
        try:
            root = ElementTree.fromstring(str.toAscii())
        except:
            print str.toAscii()
            return
        for elm in root.findall("direct_message"):
            timestamp = elm.findtext("created_at")
            statusId = elm.findtext("id")
            status = elm.findtext("text")
            sub = elm.find("sender")
            nick = sub.findtext("screen_name")
            name = sub.findtext("name")
            icon = sub.findtext("profile_image_url")
            web = sub.findtext("url")
            type = "DM"
            self.statuses.insert(
                    0,
                    ( icon, nick, status, timestamp, statusId, name, web, type))
