<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class DefaultProfile extends AppModel {
	var $name = 'DefaultProfile';
	var $displayField = 'value';

	var $fields = array(
		'edit' => array('profile_id', 'profile_select_id', 'profile_table_id', 'profile_table_static_id', 'value', 'public_flag'),
		'escape' => array(
			'value' => array(
				'html' => true,
				'tags' => true,
				'images' => true,
				'sctipts' => true,
			),
		),
	);

	var $validate = array(
		'public_flag' => array(
			'publicFlag' => array(
				'rule' => 'publicFlag',
				'allowEmpty' => true,
			),
		),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'Profile' => array(
			'className' => 'Profile',
			'foreignKey' => 'profile_id',
			'conditions' => '',
			'fields' => '',
		),
		'ProfileSelect' => array(
			'className' => 'ProfileSelect',
			'foreignKey' => 'profile_select_id',
			'conditions' => '',
			'fields' => '',
		),
		'ProfileTable' => array(
			'className' => 'ProfileTable',
			'foreignKey' => 'profile_table_id',
			'conditions' => '',
			'fields' => '',
		),
		'ProfileTableStatic' => array(
			'className' => 'ProfileTableStatic',
			'foreignKey' => 'profile_table_static_id',
			'conditions' => '',
			'fields' => '',
		),
	);

	function beforeSave($options = array())
	{
		// $fieldsの設定でSanitize
		if (isset($this->data[$this->name])) {
			$this->data[$this->name] = $this->_sanitizeByFields($this->data[$this->name]);
		}

		// Sanitize(不正コード、SQL Injection)
		if (isset($this->data)) {
			$this->data = $this->_sanitizeBasic($this->data);
		}

		return $this->data;
	}

}
