<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class CharacterSheet extends AppModel {

	var $name = 'CharacterSheet';

	var $fields = array(
		'add' => array('system_id', 'user_id', 'key_name', 'name', 'public_flag', 'sort_order'),
		'edit' => array('name', 'public_flag', 'sort_order'),
		'escape' => array(
		),
	);

	var $validate = array(
		'key_name' => array(
			'isUnique' => array(
				'rule' => array('isUnique'),
			),
			'keyNameNg' => array(
				'rule' => 'keyNameNg',
			),
			'keyName' => array(
				'rule' => 'keyName',
			),
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 40),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'name' => array(
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 64),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'system_id' => array(
			'validSystemId' => array(
				'rule' => array('validSystemId', false),
			),
		),
		'public_flag' => array(
			'publicFlag' => array(
				'rule' => 'publicFlag',
				'allowEmpty' => true,
			),
		),
		'sort_order' => array(
			'numeric' => array(
				'rule' => 'numeric',
				'allowEmpty' => true,
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'System' => array(
			'className' => 'System',
			'foreignKey' => 'system_id',
			'conditions' => array(
				'System.public_flag' => 1,
			),
			'fields' => array(
				'System.id', 
				'System.name', 
				'System.public_flag',
				'System.copyright',
			),
			'order' => ''
		),
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'conditions' => '',
			'fields' => array(
				'User.id', 
				'User.group_id',
				'User.name'
			),
		)
	);

	/* コールバックメソッド */
	function beforeSave($options = array())
	{
		if (empty($this->data['CharacterSheet']['sort_order'])) {
			$this->data['CharacterSheet']['sort_order'] = 0;
		}

		return parent::beforeSave($options);
	}
	function afterSave($created) {
		$this->deleteCache4CharcterSheet();

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4CharcterSheet();

		return parent::afterDelete();
	}

	/* キャッシュ削除 */
	function deleteCache4CharcterSheet()
	{
		// モデルキャッシュ
		$this->deleteAllFiles(CACHE);

		// ビューキャッシュ
		$this->deleteAllFiles(CACHE.'views');

/*
		if (!isset($this->Character)) {
			$this->Character = CorePlus::set_model('Character');
		}
		$this->Character->cacheDelete();

		if (!isset($this->System)) {
			$this->System = CorePlus::set_model('System');
		}
		$this->System->cacheDelete();

		// 自セッション関連
		$this->deleteCacheMyData();
*/
	}

}

