<?php
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Helper
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class LinkSelectHelper extends Helper {
	var $helpers = array(
		'Form',
	);

	/**
	 * typeの設定をview表示形式に変換
	 */
	function get_i18n_type($type, $type_list)
	{
		if (isset($type_list[$type]['title'])) {
			return $type_list[$type]['title'];
		} else {
			return null;
		}
	}
	/**
	 * typeの選択プルダウン出力
	 * i18n対応
	 */
	function create_type_select($type_list = array(), $fieldName = 'type', $options = array('type' => 'select'))
	{
		if (!isset($options['type'])) {
			$options['type'] = 'select';
		}
		if (!isset($options['options'])) {
			$options['options'] = array();
		}
		$options['options'] = $this->set_type_select($type_list, $options['options']);

		return $this->Form->input($fieldName, $options);
	}

	/* typeの設定を、key->value(プルダウン用)に変換 */
	function set_type_select($type_list = array(), $options = array())
	{
		static $i18n_type;

		if (is_array($i18n_type)) {
			return $i18n_type;
		}

		if (empty($type_list)) {
			return array();
		}

		if (!empty($options)) {
			$i18n_type = $options;
		}

		foreach ($type_list as $k => $v) {
			if (isset($v['title'])) {
				$i18n_type[$k] = $v['title'];
			}
		}

		return $i18n_type;
	}

}

