<?php 
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Element
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

echo $this->Html->css('/links/css/link.css');

?>

<div class="links listview">
<?php 
$pagenator_options = array();
$this->Paginator->options(array('url' => $this->passedArgs));

?>
<div class="box full">
<?php
echo $this->element('link_sort_header', array(
	'pagenator_options' => $pagenator_options,
	'isSimple' => true,
));
?>
<div class="boxBody">

<p>
<?php
echo $this->Paginator->counter(array(
'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
));
?>
</p>

<div class="paging">
	<?php echo $this->Paginator->prev('<< ' . __('previous', true), array(), null, array('class'=>'disabled'));?>
 | 	<?php echo $this->Paginator->numbers();?>
 |
	<?php echo $this->Paginator->next(__('next', true) . ' >>', array(), null, array('class' => 'disabled'));?>
</div>

<table cellpadding="0" cellspacing="0"<?php if ($isAdmin): ?> class="2rows"<?php endif ?>>
<tr>
	<th><?php echo $paginatorEx->sortAllow(__('Id', true), 'id', $pagenator_options);?></th>
	<th>
<?php
	echo $paginatorEx->sortAllow(__('Title', true), 'title', $pagenator_options);
	//echo $this->PaginatorEx->sortAllow('type');
	//echo $this->PaginatorEx->sortAllow('pickup');
	//echo $this->PaginatorEx->sortAllow('not_found');
	?>
</th>
	<th><?php echo $paginatorEx->sortAllow(__('URL', true), 'url', $pagenator_options);?></th>
	<th><?php echo $paginatorEx->sortAllow(__('User Name', true), 'user_id', $pagenator_options);?></th>
	<th><?php echo $this->PaginatorEx->sortAllow('modified');?></th>
</tr>
<?php
$i = 0;
foreach ($links as $link):
	$class = null;
	if ($i++ % 2 == 0) {
		$class = ' class="altrow"';
	}
?>
<tr<?php echo $class;?>>
	<td<?php if ($isAdmin): ?> rowspan="2"<?php endif ?>><?php echo $link['Link']['id']; ?>&nbsp;</td>
	<td>
<?php 
		echo $this->Html->link($link['Link']['title'], array('action' => 'view', $link['Link']['id']));
		//echo $link['Link']['type'];
		//echo $link['Link']['pickup'];
		//echo $link['Link']['not_found'];
?>
	</td>
	<td><?php echo $link['Link']['url']; ?>&nbsp;</td>
	<td><?php echo $link['User']['name']; ?>&nbsp;</td>
	<td><?php echo $link['Link']['modified']; ?>&nbsp;</td>
</tr>
<?php if ($isAdmin): ?>
<tr>
<td class="notes"<?php if ($isAdmin): ?> colspan="5"<?php endif; ?>>
	<div><?php echo $link['Link']['notes']; ?></div>
</td>
</tr>
<?php endif; ?>
<?php endforeach; ?>
</table>
</div>

<div class="paging">
	<?php echo $this->Paginator->prev('<< ' . __('previous', true), array(), null, array('class'=>'disabled'));?>
 | 	<?php echo $this->Paginator->numbers();?>
 |
	<?php echo $this->Paginator->next(__('next', true) . ' >>', array(), null, array('class' => 'disabled'));?>
</div>

<p>
<?php
	echo $this->Paginator->counter(array(
	'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
	));
?>
</p>

</div>
