<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class CharacterProfileArchive extends AppModel {

	var $name = 'CharacterProfileArchive';

	var $fields = array(
		'add' => array('character_id', 'value', 'title', 'memo', 'public_flag', 'disp_date'),
		'edit' => array('title', 'memo', 'public_flag', 'disp_date'),
		'escape' => array(
			'title' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
			'memo' => array(
				'html' => true,
				'tags' => true,
				'images' => true,
				'sctipts' => true,
			),
		),
	);

	var $validate = array(
		'title' => array(
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 64),
				'allowEmpty' => true,
			),
		),
		'public_flag' => array(
			'publicFlag' => array(
				'rule' => 'publicFlag',
				'allowEmpty' => true,
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'Character' => array(
			'className' => 'Character',
			'foreignKey' => 'character_id',
			'conditions' => '',
			'fields' => array(
				'Character.id',
				'Character.user_id',
				'Character.name',
				'Character.public_flag',
			),
			'order' => ''
		)
	);

	/* コールバックメソッド */
	function afterFind($results, $primary = false) {
		if (empty($results)) {
			return $results;
		}

		foreach ($results as $key => $result) {
			/* valueのunsecape */
			if (isset($result[$this->alias]['value'])) {
				$results[$key][$this->alias]['value'] = $this->restore_escape($result[$this->alias]['value'], false, false, false);
			}
		}

		return parent::afterFind($results, $primary);
	}

	function afterSave($created) {
		$this->deleteCache4ProfileArchive($this->data['clearCache']['character_id']);

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4ProfileArchive($this->data['clearCache']['character_id']);

		return parent::afterDelete();
	}

	/* キャッシュ削除 */
	function deleteCache4ProfileArchive($character_id)
	{
		// index, view
		$this->deleteCache4ProfileArchives($character_id);

		// キャラクターview
		$this->deleteCacheCharacterView($character_id, true);
	}

	function deleteCache4ProfileArchives($character_id)
	{
		$this->cacheDelete();

		// index
		$this->deleteCache4ProfileArchivesIndex($character_id);
		// view
		$this->deleteCache4ProfileArchivesViews($this->id);
	}
	function deleteCache4ProfileArchivesViews($ids)
	{
		if (!is_array($ids)) {
			$ids = (array)$ids;
		}

		if (!empty($ids)) {
			$Session = CorePlus::set_behavoir('Session');

			foreach ($ids as $id) {
				if (file_exists(CACHE.'views'.DS.'element_'.$id.'_character_profile_archive_view')) {
					@unlink(CACHE.'views'.DS.'element_'.$id.'_character_profile_archive_view');
				}
				if (file_exists(CACHE.'views'.DS.'element_'.$Session->id().'_'.$id.'_character_profile_archive_view')) {
					@unlink(CACHE.'views'.DS.'element_'.$Session->id().'_'.$id.'_character_profile_archive_view');
				}
			}
		}
	}
}

