<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  参加者リストから削除
 *******************/

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/member_check.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

$name = htmlspecialchars($request['n']);
$exe_name = htmlspecialchars($request['en']);
if (!$name || $ene_name) {
    error('名前を入力してください', true);
}

$pwd = create_hash($name, $request['pwd']);

if (OBFUSCATION) {
    $name = obf_xor($name);
}

// ファイルロック
$lfp = fopen(LOCK2,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

$now_member = get_member_log();

$delete_flg = false;
if (!$now_member) {
    error_log("参加者がいません");
} else {

    // 参加者名チェック
    foreach($now_member as $k => $v) {
        if ($name == $v[0]) {
            // パスワードチェック
            // マスターパスあるいは合致した場合
            if ($request['pwd'] == MASTERPASS || $pwd == $v[1]) {
//                error_log($request['n']." deleted by ".$exe_name);
                $delete_flg = true;
                unset($now_member[$k]);
                break;
            }
        }
    }

    // ログファイル更新
    if ($delete_flg) {
        $fpm = @fopen(NOW_MEMBER, "w+");
        if (count($now_member) != 0) {
            foreach($now_member as $k => $v) {
                fwrite($fpm, implode($v, "<>"));
            }
        }

        //$bom = "\xef\xbb\xbf";
        //fwrite($fpm, $bom);

        fclose($fpm);
    }
}
// ロック解除
fflush($lfp);
fclose($lfp);

if ($delete_flg) {
    $result = "deleted";
} else {
    $result = "not deleted";
}

// return
echo $result;

exit;
