/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

#include "kernel_impl.h"
#include "task.h"

extern const intptr_t	tinib_exinf[];			/* ^XN̊g */
extern const TASK    	tinib_task[];			/* ^XN̋NԒn */
extern const uint_t  	tinib_ipriority[];		/* ^XN̏Dxi\jNDxȉ̒l */


/*
 * sԃ^XN̏Dx
 */
uint_t runtsk_ipri;

/*
 *  fBL[T[`̂߂̃rbg}bv
 */
uint16_t	ready_primap;

/*
 *  ^XNfBXpb`NvtO
 */
bool_t	reqflg;

/*
 *  fBXpb`֎~
 */
bool_t	disdsp;

/*
 *  read_primap̏l
 */
extern const uint_t init_rdypri;


/*
 *  rbg}bvT[`֐
 *
 *  bitmap1̃rbg̓CłʁiEĵ̂T[`C̃rb
 *  gԍԂDrbgԍ́Cŉʃrbg0ƂDbitmap0w
 *  Ă͂ȂȂD̊֐ł́Cbitmap16rbgł邱Ƃ肵C
 *  uint16_t^ƂĂD
 *
 *  rbgT[`߂vZbTł́CrbgT[`߂g悤
 *  ǂꍇD̂悤ȏꍇɂ́C^[Qbg
 *  ˑŃrbgT[`߂gbitmap_search`C
 *  OMIT_BITMAP_SEARCH}N`΂悢D܂CrbgT[`߂
 *  T[`tȂǂ̗RŗDxƃrbgƂ̑ΉύXꍇ
 *  ́CPRIMAP_BIT}N`΂悢D
 *
 *  ܂CWCuffsȂĈ悤ɒ`ĕWCu
 *  gǂ\D
 *		#define	bitmap_search(bitmap) (ffs(bitmap) - 1)
 */
#ifndef PRIMAP_BIT
#define	PRIMAP_BIT(pri)		(1U << (pri))
#endif /* PRIMAP_BIT */

#ifndef OMIT_BITMAP_SEARCH

static const uint8_t bitmap_search_table[] = { 0, 1, 0, 2, 0, 1, 0,
												3, 0, 1, 0, 2, 0, 1, 0 };

uint_t
bitmap_search(uint_t bitmap)
{
	uint_t	n = 0U;

	if ((bitmap & 0x0fU) == 0U) {
		bitmap >>= 4;
		n += 4;
	}
	return (n + bitmap_search_table[(bitmap & 0x0fU) - 1]);
}

#endif /* OMIT_BITMAP_SEARCH */

/*
 *  Dxrbg}bv󂩂̃`FbN
 */
Inline bool_t
primap_empty(void)
{
	return (ready_primap == 0U);
}

/*
 *  wrbgZbgĂ邩ǂ̃`FbN
 */
Inline bool_t
primap_test(uint_t bit)
{
	return ((ready_primap & (1U << bit)) != 0U);
}

/*
 *  Dxrbg}bṽT[`
 */
Inline uint_t
primap_search(void)
{
	return bitmap_search(ready_primap);
}

/*
 *  Dxrbg}bṽZbg
 */
Inline void
primap_set(uint_t pri)
{
	ready_primap |= PRIMAP_BIT(pri);
}

/*
 *  Dxrbg}bṽNA
 */
Inline void
primap_clear(uint_t pri)
{
	ready_primap &= ~PRIMAP_BIT(pri);
}



/*
 *  ōD揇ʃ^XÑT[`
 */

uint_t
search_schedtsk(void)
{
	return primap_search();
}

/*
 * w^XNsłԂǂ̃eXg
 *
 * słꍇtrueԂD
 */
bool_t
test_dormant(uint_t pri)
{
	return !primap_test(pri);
}



/*
 *  ^XNǗW[̏
 */
void
initialize_task(void)
{
	/* fBL[̃rbg}bv */
	ready_primap = init_rdypri;
	
	/* sDx̏ */
	runtsk_ipri = UINT_MAX;
	
	/* ݋֎~tȌ */
	disdsp = false;
}


/*
 *  pri : NΏۃ^XN̋NDx(\)
 */
bool_t
make_active(uint_t pri) {
	primap_set(pri);
	
	if(pri < runtsk_ipri) {
		return !disdsp;
	}
	else {
		return false;
	}
}



/*
 *  apri : sJn^XN̋NDx
 *  ĂяoF CPUbN
 */
void
run_task(uint_t apri)
{
	uint_t next_apri;	/* ɎsJn^XN̋NDx */
	uint_t saved_ipri;	/* Ăяo^XN̏Dx */
	
	next_apri = apri;
	saved_ipri = runtsk_ipri;
	
	do {
		// ͎sDxɕύX
		runtsk_ipri = tinib_ipriority[next_apri];
	
		/* CPUbN */
		t_unlock_cpu();
		(*((TASK)(tinib_task[next_apri])))(tinib_exinf[next_apri]); /* ^XNsJn */
		
		if (t_sense_lock()) {
			/*
			 *  CPUbNԂext_tskĂ΂ꂽꍇ́CCPUbN
			 *  Ă^XNID́CT[rXR[łCPU
			 *  bNȗ΂悢D
			 */
		}
		else {
			t_lock_cpu();
		}
		
		/* ݗDx}XN͑SԂ̂͂Ȃ̂ŁCȂ */
		
		/*
		 *  fBXpb`֎~Ԃext_tskĂ΂ꂽꍇ́CfBXpb
		 *  `ԂɂĂ^XNID
		 *
		 *	{͈ȉ̂悤ɋLqׂł邪Cɂdisdsp
		 *	falseɂ΂߁CPfalseɐݒ肷D
		 *
		 *		if (disdsp) {
		 *			disdsp = false;
		 *		}
		 */
		disdsp = false;
		
		/* rbg}bvNADL[COĂꍇ́CJE^炷ŃNAȂ */
		primap_clear(next_apri);
		
	  /* ߂^XN̏Dx荂NDx^XNNꂽ */
	} while(!primap_empty() && saved_ipri > (next_apri = search_schedtsk()));
	
	runtsk_ipri = saved_ipri;
}

/*
 *  ̊֐͑S݃bNԂƓ̏Ԃ sta_ker Ă΂
 */
void
dispatcher(void)
{
	for(;;){
		if(!primap_empty()) {
			/* ^XN̊Jn */
			run_task(search_schedtsk());
		}
		else {
			idle_loop();
		}
	}
}
