/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *  M32C/87Ɉˑ`
 */


#ifndef TOPPERS_M32C87_H
#define TOPPERS_M32C87_H

/*
 *  CPUOnhԍ̒`
 */

#define INT_UNDEF_INSTRUNCTION	0		/* ` */
#define INT_OVERFLOW			1		/* I[o[t[ */
#define INT_BRK_INSTRUCTION		2		/* BRK */
#define INT_ADDRESS_MATCH		3		/* AhXv */
#define INT_WDT					5		/* EHb`hbO^C} */
#define INT_XIN_STOP			5		/* U~o */
#define INT_LOW_VOLT_DETECT		5		/* dቺo */
#define INT_NMI					7		/* NMI */
#define INT_RESET				8		/* Zbg */

/*
 *  ݔԍ̒`
 */
#define	INT_BRK					0		/* BRK */
#define INT_AD1					7		/* A-Dϊ1 */
#define INT_DMA0				8		/* DMA0 */
#define INT_DMA1				9		/* DMA1 */
#define INT_DMA2				10		/* DMA2 */
#define INT_DMA3				11		/* DMA3 */
#define INT_TA0					12		/* ^C}A0 */
#define INT_TA1					13		/* ^C}A1 */
#define INT_TA2					14		/* ^C}A2 */
#define INT_TA3					15		/* ^C}A3 */
#define INT_TA4					16		/* ^C}A4 */
#define INT_S0TNACK				17		/* UART0M,NACK */
#define INT_S0RACK				18		/* UART0M,ACK */
#define INT_S1TNACK				19		/* UART1M,NACK */
#define INT_S1RACK				20		/* UART1M,ACK */
#define INT_TB0					21		/* ^C}B0 */
#define INT_TB1					22		/* ^C}B1 */
#define INT_TB2					23		/* ^C}B2 */
#define INT_TB3					24		/* ^C}B3 */
#define INT_TB4					25		/* ^C}B4 */
#define INT_INT5				26		/* INT5 */
#define INT_INT4				27		/* INT4 */
#define INT_INT3				28		/* INT3 */
#define INT_INT2				29		/* INT2 */
#define INT_INT1				30		/* INT1 */
#define INT_INT0				31		/* INT0 */
#define INT_TB5					32		/* ^C}B5 */
#define INT_S2TNACK 			33		/* UART2M,NACK */
#define INT_S2RACK 				34		/* UART2M,ACK */
#define INT_S3TNACK 			35		/* UART3M,NACK */
#define INT_S3RACK 				36		/* UART3M,ACK */
#define INT_S4TNACK 			37		/* UART4M,NACK */
#define INT_S4RACK 				38		/* UART4M,ACK */

#define INT_AD0					42		/* A-Dϊ0 */
#define INT_KEY					43		/* L[͊荞 */
#define INT_IIO0				44		/* CeWFgI/O0 */
#define INT_IIO1				45		/* CeWFgI/O1 */
#define INT_IIO2				46		/* CeWFgI/O2 */
#define INT_IIO3				47		/* CeWFgI/O3 */
#define INT_IIO4				48		/* CeWFgI/O4 */
#define INT_IIO5				49		/* CeWFgI/O5 */
#define INT_IIO6				50		/* CeWFgI/O6 */
#define INT_IIO7				51		/* CeWFgI/O7 */
#define INT_IIO8				52		/* CeWFgI/O8 */
#define INT_IIO9CAN0			53		/* CeWFgI/O9,CAN0 */
#define INT_IIO10CAN			54		/* CeWFgI/O10,CAN1 */
#define INT_IIO11CAN			57		/* CeWFgI/O11,CAN2 */


/*
 *  ėp|[gWX^(ꕔC144sł̂)
 */
#define TADR_SFR_P0 			0x3e0		/* |[gP0WX^ */
#define TADR_SFR_P1 			0x3e1		/* |[gP1WX^ */
#define TADR_SFR_PD0			0x3e2		/* |[gP0WX^ */
#define TADR_SFR_PD1			0x3e3		/* |[gP1WX^ */
#define TADR_SFR_P2 			0x3e4		/* |[gP2WX^ */
#define TADR_SFR_P3 			0x3e5		/* |[gP3WX^ */
#define	TADR_SFR_PD2			0x3e6		/* |[gP2WX^ */
#define	TADR_SFR_PD3			0x3e7		/* |[gP3WX^ */
#define TADR_SFR_P4 			0x3e8		/* |[gP4WX^ */
#define	TADR_SFR_P5 			0x3e9		/* |[gP5WX^ */
#define	TADR_SFR_PD4			0x3ea		/* |[gP4WX^ */
#define	TADR_SFR_PD5			0x3eb		/* |[gP5WX^ */
#define TADR_SFR_P6 			0x3c0		/* |[gP6WX^ */
#define	TADR_SFR_P7 			0x3c1		/* |[gP7WX^ */
#define	TADR_SFR_PD6			0x3c2		/* |[gP6WX^ */
#define	TADR_SFR_PD7			0x3c3		/* |[gP7WX^ */
#define	TADR_SFR_P8 			0x3c4		/* |[gP8WX^ */
#define TADR_SFR_P9 			0x3c5		/* |[gP9WX^ */
#define	TADR_SFR_PD8			0x3c6		/* |[gP8WX^ */
#define TADR_SFR_PD9			0x3c7		/* |[gP9WX^ */
#define TADR_SFR_P10			0x3c8		/* |[gP10WX^ */
#define TADR_SFR_P11			0x3c9		/* |[gP11WX^(144sł̂) */
#define TADR_SFR_PD10			0x3ca		/* |[gP10WX^ */
#define TADR_SFR_PD11			0x3cb		/* |[gP11WX^(144sł̂) */
#define TADR_SFR_P12			0x3cc		/* |[gP12WX^(144sł̂) */
#define TADR_SFR_P13			0x3cd		/* |[gP13WX^(144sł̂) */
#define TADR_SFR_PD12			0x3ce		/* |[gP12WX^(144sł̂) */
#define TADR_SFR_PD13			0x3cf		/* |[gP13WX^(144sł̂) */
#define TADR_SFR_P14			0x3d0		/* |[gP14WX^(144sł̂) */
#define TADR_SFR_P15			0x3d1		/* |[gP15WX^(144sł̂) */
#define TADR_SFR_PD14			0x3d2		/* |[gP14WX^(144sł̂) */
#define TADR_SFR_PD15			0x3d3		/* |[gP15WX^(144sł̂) */

#define	TADR_SFR_PUR0			0x3f0		/* vAbv䃌WX^O */
#define	TADR_SFR_PUR1			0x3f1		/* vAbv䃌WX^P */
#define	TADR_SFR_PUR2			0x3da		/* vAbv䃌WX^Q */
#define	TADR_SFR_PUR3			0x3db		/* vAbv䃌WX^R */
#define	TADR_SFR_PUR4			0x3dc		/* vAbv䃌WX^S(144sł̂) */

#define	TADR_SFR_PCR			0x3ff		/* |[g䃌WX^ */

#define TADR_SFR_PS0			0x3b0		/* @\IWX^A0 */
#define TADR_SFR_PS1			0x3b1		/* @\IWX^A1 */
#define TADR_SFR_PS2			0x3b4		/* @\IWX^A2 */
#define TADR_SFR_PS3			0x3b5		/* @\IWX^A3 */
#define TADR_SFR_PS5			0x3b9		/* @\IWX^A5(144sł̂) */
#define TADR_SFR_PS6			0x3bc		/* @\IWX^A6(144sł̂) */
#define TADR_SFR_PS7			0x3bd		/* @\IWX^A7(144sł̂) */
#define TADR_SFR_PS8			0x3a0		/* @\IWX^A8(144sł̂) */
#define TADR_SFR_PS9			0x3a1		/* @\IWX^A9(144sł̂) */

#define TADR_SFR_PSL0			0x3b2		/* @\IWX^B0 */
#define TADR_SFR_PSL1			0x3b3		/* @\IWX^B1 */
#define TADR_SFR_PSL2			0x3b6		/* @\IWX^B2 */
#define TADR_SFR_PSL3			0x3b7		/* @\IWX^B3 */

#define TADR_SFR_PSC			0x3af		/* @\IWX^C */


/*
 *  ݐ䃌WX^`
 */
#define TA0IC		((volatile uint8_t *)0x6C)
#define TA1IC		((volatile uint8_t *)0x8C)
#define TA2IC		((volatile uint8_t *)0x6E)
#define TA3IC		((volatile uint8_t *)0x8E)
#define TA4IC		((volatile uint8_t *)0x70)
#define TB0IC		((volatile uint8_t *)0x94)
#define TB1IC		((volatile uint8_t *)0x76)
#define TB2IC		((volatile uint8_t *)0x96)
#define TB3IC		((volatile uint8_t *)0x78)
#define TB4IC		((volatile uint8_t *)0x98)
#define TB5IC		((volatile uint8_t *)0x69)
#define S0TIC		((volatile uint8_t *)0x90)
#define S1TIC		((volatile uint8_t *)0x92)
#define S2TIC		((volatile uint8_t *)0x89)
#define S3TIC		((volatile uint8_t *)0x8B)
#define S4TIC		((volatile uint8_t *)0x8D)
#define S0RIC		((volatile uint8_t *)0x72)
#define S1RIC		((volatile uint8_t *)0x74)
#define S2RIC		((volatile uint8_t *)0x6B)
#define S3RIC		((volatile uint8_t *)0x6D)
#define S4RIC		((volatile uint8_t *)0x6F)
#define BCN0IC		((volatile uint8_t *)0x71)
#define BCN1IC		((volatile uint8_t *)0x91)
#define BCN2IC		((volatile uint8_t *)0x8F)
#define BCN3IC		((volatile uint8_t *)0x71)
#define BCN4IC		((volatile uint8_t *)0x91)
#define DMO0IC		((volatile uint8_t *)0x68)
#define DMO1IC		((volatile uint8_t *)0x88)
#define DMO2IC		((volatile uint8_t *)0x6A)
#define DMO3IC		((volatile uint8_t *)0x8A)
#define AD0IC		((volatile uint8_t *)0x73)
#define KUPIC		((volatile uint8_t *)0x93)
#define IIO0IC		((volatile uint8_t *)0x75)
#define IIO1IC		((volatile uint8_t *)0x95)
#define IIO2IC		((volatile uint8_t *)0x77)
#define IIO3IC		((volatile uint8_t *)0x97)
#define IIO4IC		((volatile uint8_t *)0x79)
#define IIO8IC		((volatile uint8_t *)0x7D)
#define IIO9IC		((volatile uint8_t *)0x9D)
#define IIO10IC		((volatile uint8_t *)0x7F)
#define CAN0IC		((volatile uint8_t *)0x9D)
#define CAN1IC		((volatile uint8_t *)0x7F)
#define CAN2IC		((volatile uint8_t *)0x81)
#define CAN3IC		((volatile uint8_t *)0x75)
#define CAN4IC		((volatile uint8_t *)0x95)
#define CAN5IC		((volatile uint8_t *)0x99)

#define INT0IC		((volatile uint8_t *)0x9E)
#define INT1IC		((volatile uint8_t *)0x7E)
#define INT2IC		((volatile uint8_t *)0x9C)
#define INT3IC		((volatile uint8_t *)0x7C)
#define INT4IC		((volatile uint8_t *)0x9A)
#define INT5IC		((volatile uint8_t *)0x7A)

/*
 *  ^C}A֘A̒`
 *
 *  pdicm16c/m16c_ta.cŎgpD
 */

/*
 *  ^C}Ǎ
 */
#define TNUM_M16C_TA		(5)

/*
 *  e`l̃WX^yѐݒrbg
 */
#define TA0_ADDR			(0x346)
#define TA0MR_ADDR			(0x356)
#define TA0_START_BIT		(0x01U << 0U)
#define TA0_ONESHOT_BIT		(0x01U << 0U)
#define TA0_UDSEL_BIT		(0x01U << 0U)
#define TA0_TRIGSEL_OFFSET	(6U)

#define TA1_ADDR			(0x348)
#define TA1MR_ADDR			(0x357)
#define TA1_START_BIT		(0x01U << 1U)
#define TA1_ONESHOT_BIT		(0x01U << 1U)
#define TA1_UDSEL_BIT		(0x01U << 1U)
#define TA1_TRIGSEL_OFFSET	(0U)

#define TA2_ADDR			(0x34A)
#define TA2MR_ADDR			(0x358)
#define TA2_START_BIT		(0x01U << 2U)
#define TA2_ONESHOT_BIT		(0x01U << 2U)
#define TA2_UDSEL_BIT		(0x01U << 2U)
#define TA2_TRIGSEL_OFFSET	(2U)

#define TA3_ADDR			(0x34C)
#define TA3MR_ADDR			(0x359)
#define TA3_START_BIT		(0x01U << 3U)
#define TA3_ONESHOT_BIT		(0x01U << 3U)
#define TA3_UDSEL_BIT		(0x01U << 3U)
#define TA3_TRIGSEL_OFFSET	(4U)

#define TA4_ADDR			(0x34E)
#define TA4MR_ADDR			(0x35A)
#define TA4_START_BIT		(0x01U << 4U)
#define TA4_ONESHOT_BIT		(0x01U << 4U)
#define TA4_UDSEL_BIT		(0x01U << 4U)
#define TA4_TRIGSEL_OFFSET	(6U)

/* ^C}̊e`lŋp郌WX^ */
#define TABSR_ADDR			(0x340U)
#define UDF_ADDR			(0x344U)
#define ONSF_ADDR			(0x342U)
#define TAGSR_ADDR			(0x343U)

/*
 *  UART֘A̒`
 *
 *  pdicm16c/m16c_uart.cŎgpD
 */

/*
 *  VAI/Ǒ
 */
#define TNUM_SIOP			(5)

/*
 *  e|[g̃WX^yѐݒrbg
 */

#define UART0_UC0_ADDR		(0x36C)
#define UART0_UC1_ADDR		(0x36D)
#define UART0_MODE_ADDR		(0x368)
#define UART0_BAUD_ADDR		(0x369)
#define UART0_TXBUF_ADDR	(0x36A)
#define UART0_RXBUF_ADDR	(0x36E)
#define UART0_TXINTNO		(INT_S0TNACK)
#define UART0_RXINTNO		(INT_S0RACK)

#define UART1_UC0_ADDR		(0x2EC)
#define UART1_UC1_ADDR		(0x2ED)
#define UART1_MODE_ADDR		(0x2E8)
#define UART1_BAUD_ADDR		(0x2E9)
#define UART1_TXBUF_ADDR	(0x2EA)
#define UART1_RXBUF_ADDR	(0x2EE)
#define UART1_TXINTNO		(INT_S1TNACK)
#define UART1_RXINTNO		(INT_S1RACK)

#define UART2_UC0_ADDR		(0x33C)
#define UART2_UC1_ADDR		(0x33D)
#define UART2_MODE_ADDR		(0x338)
#define UART2_BAUD_ADDR		(0x339)
#define UART2_TXBUF_ADDR	(0x33A)
#define UART2_RXBUF_ADDR	(0x33E)
#define UART2_TXINTNO		(INT_S2TNACK)
#define UART2_RXINTNO		(INT_S2RACK)

#define UART3_UC0_ADDR		(0x32C)
#define UART3_UC1_ADDR		(0x32D)
#define UART3_MODE_ADDR		(0x328)
#define UART3_BAUD_ADDR		(0x329)
#define UART3_TXBUF_ADDR	(0x32A)
#define UART3_RXBUF_ADDR	(0x32E)
#define UART3_TXINTNO		(INT_S3TNACK)
#define UART3_RXINTNO		(INT_S3RACK)

#define UART4_UC0_ADDR		(0x2FC)
#define UART4_UC1_ADDR		(0x2FD)
#define UART4_MODE_ADDR		(0x2F8)
#define UART4_BAUD_ADDR		(0x2F9)
#define UART4_TXBUF_ADDR	(0x2FA)
#define UART4_RXBUF_ADDR	(0x2FE)
#define UART4_TXINTNO		(INT_S4TNACK)
#define UART4_RXINTNO		(INT_S4RACK)


#endif	/* TOPPERS_M32C87_H */
