/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: start.S 1304 2008-08-27 07:28:36Z ertl-honda $
 */
                
/*
 *   ͥѤΥȥåץ⥸塼(ARM-M)
 */
#define TOPPERS_MACRO_ONLY
#define UINT_C(val)		(val)		/* uint_tޥ */
#define ULONG_C(val)	(val)		/* ulong_tޥ */
#define CAST(type, val)	(val)		/* 㥹ȤԤޥ */

#include "kernel_impl.h"
#include "arm_m.h"

/*
 *  ȥåץ롼
 *
 *  Thread⡼ɤǸƤӽФ뤳ȤȤƤ롥
 */
	.text
	.align 2
	.code 16
	.syntax unified
	.globl _start
	.type _start, function
_start:
	cpsid f                 /* ߥå֤ */

#ifdef INIT_MSP
	/*
	 * MSP
	 */
	mov   r0, #CONTROL_MSP  /* MSPͭ  */
	msr   control, r0
	isb                     /* control ɬ */
	ldr  r0,=_kernel_istkpt
	ldr  r1,[r0]
	msr  msp, r1
#endif /* INIT_MSP */

	/*
	 * hardware_init_hookθƤӽФ 0Ǥʤ
	 *
	 * åȥϡɥ˰¸ɬפʽ
	 * ϡhardware_init_hook ȤؿѰդ
	 */
	ldr  r0, =hardware_init_hook
	cbz  r0, start_1
	blx  r0

start_1:
#ifndef OMIT_BSS_INIT
	/*
	 *  BSS
	 */
	mov  r0, #0
	ldr  r1, =__bss_start
	ldr  r2, =__bss_end
	cmp  r1, r2
	bhs  start_3
start_2:
	str  r0, [r1]
	add  r1,r1, #4    
	cmp  r1, r2
	blo  start_2
#endif /* OMIT_BSS_INIT */


start_3:

#ifndef OMIT_DATA_INIT
	/*
	 *  DATA
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ
	 *  ԡ
	 */
	ldr  r1, =__idata_start
	ldr  r2, =__idata_end
	cmp  r1, r2
	bhs  start_5
	ldr  r3, =__data_start
start_4:
	ldr  r0, [r1]
	str  r0, [r3]
	add  r1, #4
	add  r3, #4
	cmp  r1, r2
	blo  start_4
#endif /* OMIT_DATA_INIT */

	/*
	 *  software_init_hook ƽФ0 Ǥʤ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ
	 *  褤
	 */
start_5:
	ldr  r0, =software_init_hook
	cbz  r0, start_6
	blx  r0

start_6:
	bl   sta_ker

l_end:
	b   l_end
