﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace Somali
{
    static partial class Util
    {
        /// <summary>
        /// フォルダセレクター
        /// </summary>
        /// <returns></returns>
        public delegate string FolderSelector();

        #region getPathMethod
        /// <summary>
        /// フォルダパス取得
        /// </summary>
        /// <param name="folderSelector"></param>
        /// <returns>フォルダパス</returns>
        /// <remarks>フォルダパス取得します。フォルダが存在しない場合は、ディレクトリを生成します。</remarks>
        public static string GetDirPathWithCreate( FolderSelector folderSelector )
        {
            string strDirPath = folderSelector();

            //フォルダの存在検査
            if ( !Directory.Exists( strDirPath ) )
            {
                //存在しない場合、ディレクトリを生成する
                Directory.CreateDirectory( strDirPath );
            }

            return strDirPath;
        }

        /// <summary>
        /// 設定データ保存フォルダパス取得
        /// </summary>
        /// <returns>設定データ保存フォルダパス</returns>
        public static string GetAppSettingDir()
        {
            return GetAppDefaultDir() + @"\Settings";
        }

        /// <summary>
        /// プロジェクトデータ保存フォルダパス取得
        /// </summary>
        /// <returns>プロジェクトデータ保存フォルダパス</returns>
        public static string GetAppProjectDir()
        {
            return GetAppDefaultDir() + @"\Project";
        }

        /// <summary>
        /// Tempデータ保存フォルダパス取得
        /// </summary>
        /// <returns>Tempデータ保存フォルダパス</returns>
        public static string GetAppTempDir()
        {
            return GetAppDefaultDir() + @"\Temp";
        }

        /// <summary>
        /// データ保存デフォルトフォルダパス取得
        /// </summary>
        /// <returns>デフォルトフォルダパス</returns>
        private static string GetAppDefaultDir()
        {
            return String.Format( @"{0}\{1}"
                                , Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData )
                                , Application.ProductName );
        }
        #endregion


    }
}
