﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Linq;
using System.Xml.Linq;

namespace Somali.EnvControl
{
    class PreferencesSecretary : Somali.Base.BaseSecretary
    {
        // アプリケーション設定情報ファイル名
        private readonly string preferencesFileName = global::Somali.Properties.Resources.PREFERENCES_FILE;

        // 設定情報読込
        private XElement LoadPreferences()
        {
            string dirPath = Util.GetAppSettingDir();
            string filePath = String.Format( @"{0}\{1}", dirPath, preferencesFileName );

            return LoadXmlFile( filePath );
        }

        // 設定情報書込
        private void SavePreferences( XElement root )
        {
            string dirPath = Util.GetDirPathWithCreate( new Util.FolderSelector( Util.GetAppSettingDir ) );
            string filePath = String.Format( @"{0}\{1}", dirPath, preferencesFileName );

            SaveXmlFile( filePath, root );
        }


        /// <summary>
        /// 初期状態設定情報の読込
        /// </summary>
        public void InitPreferences()
        {
            XElement prefXml = LoadPreferences();
            if ( prefXml == null )
            {
                SaveDefaultPreferences();
            }

            // TODO:設定の反映

        }

        // デフォルト設定情報保存
        private void SaveDefaultPreferences()
        {
            // TODO:デフォルト設定情報の作成
            XElement prefXml = new XElement( "SomaliSettings",
                            new XElement( "Environment",
                                new XElement( "TextDrawing",
                                    new XElement( "DrawEolCode", true ),
                                    new XElement( "DrawFullWidthSpace", true ) ) ),
                            new XElement( "FileType",
                                new XElement( "CppFileType",
                                    new XElement( "Extensions",
                                        new XElement( "value", ".c" ),
                                        new XElement( "value", ".cpp" ),
                                        new XElement( "value", ".cxx" ),
                                        new XElement( "value", ".h" ),
                                        new XElement( "value", ".hpp" ),
                                        new XElement( "value", ".hxx" ) ) ) ) );

            SavePreferences( prefXml );
        }

        public void SavePreferneces( string tag, object value )
        {

        }
    }
}
