﻿using System;
using System.Windows.Forms;
using System.ComponentModel;

namespace Somali.Base
{
    public class SomaliBaseForm : Form
    {

        #region windowStateEvent
        [Category("配置")]
        [Description("WindowStateが変更される前に発生します。")]
        public event EventHandler<WindowStateChangingEventArgs> WindowStateChanging;
        protected bool OnWindowStateChanging( WindowStateChangingEventArgs e )
        {
            if ( WindowStateChanging != null )
            {
                WindowStateChanging( this, e );
            }
            return e.Cancel;
        }

        [Category( "配置" )]
        [Description( "WindowStateが変更された後に発生します。" )]
        public event EventHandler<WindowStateChangedEventArgs> WindowStateChanged;
        protected void OnWindowStateChanged( WindowStateChangedEventArgs e )
        {
            if ( WindowStateChanged != null )
            {
                WindowStateChanged( this, e );
            }
        }

        protected override void WndProc( ref System.Windows.Forms.Message m )
        {
            const int WM_SYSCOMMAND = 0x112;
            const int SC_RESTORE = 0xf120;
            const int SC_MINIMIZE = 0xf020;
            const int SC_MAXIMIZE = 0xf030;

            if ( m.Msg == WM_SYSCOMMAND )
            {

                int wparam = m.WParam.ToInt32() & 0xfff0;
                switch ( wparam )
                {
                    case SC_MINIMIZE:
                        if ( this.OnWindowStateChanging( new WindowStateChangingEventArgs( FormWindowState.Minimized ) ) == true )
                        {
                            return;
                        }
                        base.WndProc( ref m );
                        this.OnWindowStateChanged( new WindowStateChangedEventArgs( FormWindowState.Minimized ) );
                        return;

                    case SC_MAXIMIZE:
                        if ( this.OnWindowStateChanging( new WindowStateChangingEventArgs( FormWindowState.Maximized ) ) == true )
                        {
                            return;
                        }
                        base.WndProc( ref m );
                        this.OnWindowStateChanged( new WindowStateChangedEventArgs( FormWindowState.Maximized ) );
                        return;

                    case SC_RESTORE:
                        if ( this.OnWindowStateChanging( new WindowStateChangingEventArgs( FormWindowState.Normal ) ) == true )
                        {
                            return;
                        }
                        base.WndProc( ref m );
                        this.OnWindowStateChanged( new WindowStateChangedEventArgs( FormWindowState.Normal ) );
                        return;

                }
            }

            base.WndProc( ref m );
        }
        #endregion

    }
}
