﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;
using System.Text;

namespace Somali.Base
{
    abstract class BaseSecretary
    {

        protected void SaveXmlFile( string filePath, XElement xmlRoot )
        {
            XIO xmlIO = new XIO( xmlRoot );

            if ( xmlIO.HasRoot() )
            {
                xmlIO.SaveXML( filePath );
            }
        }

        protected void SaveXmlFileByTag( string filePath, string tag, object value )
        {
            XIO xmlIO = new XIO();
            xmlIO.LoadXML( filePath );
            xmlIO.ReplaceValueByTag( tag, value );
            xmlIO.SaveXML( filePath );
        }

        protected void SaveXmlFileByTag( string filePath, IDictionary<string, object> valueMap )
        {
            XIO xmlIO = new XIO();
            xmlIO.LoadXML( filePath );

            foreach ( KeyValuePair<string, object> kvp in valueMap )
            {
                xmlIO.ReplaceValueByTag( kvp.Key, kvp.Value );
            }

            xmlIO.SaveXML( filePath );
        }

        protected XElement LoadXmlFile( string filePath )
        {
            XIO xmlIO = new XIO();
            xmlIO.LoadXML( filePath );
            return xmlIO.RootElement;
        }

        protected string GetValueByTag( XElement element, string tag )
        {
            return XIO.GetValueByTag( element, tag );
        }
    }
}
