#include <stdio.h>
#include <stdlib.h>
#include <p24FJ64GA004.h>
#include <libpic30.h>
#include <string.h>
#include "myuart.h"
#include "myspi.h"
#include "debug_print.h"
#include "ublox.h"
#include "myad.h"
#include "delay.h"
#include "ring.h"
#include "byte2var.h"
#include "myint.h"
#include "mysts.h"

/**** TEST *******************************************/
/*
 * SPI FLAG test
 */
void test_spi_flag(void)
{
    char    sz[128];
    int in;
    unsigned char txc = 0;
    unsigned char rxc;

//    spi2_int_disable();
//    cnint_int_disable();
    while(1) {
        delay_ms(1000);
        sprintf(sz, "SPI2STAT=%04X "
                "SPIBEC=%d SRMPT=%d SPIROV=%d SRXMPT=%d TBF=%d RBF=%d\r\n"
                , SPI2STAT
                , SPI2STATbits.SPIBEC
                , SPI2STATbits.SRMPT
                , SPI2STATbits.SPIROV
                , SPI2STATbits.SRXMPT
                , SPI2STATbits.SPITBF
                , SPI2STATbits.SPIRBF
                );
        PDEBUG(sz);
        if ((in = uart2_rcvbuf_getc()) >= 0) {
            uart2_myputc(in);
            uart2_puts("\r\n");

            switch(in) {
                case 'r':
                    rxc = spi2_getc();
                    sprintf(sz, "RX=%02X\r\n", rxc);
                    uart2_puts(sz);
                    break;
                case 't':
                    spi2_putc(txc++);
                    sprintf(sz, "TX=%02X\r\n", txc);
                    uart2_puts(sz);
                    break;
                case 'v':
                    spi2_rx_overrun_clear();
                    break;
                case 'x':
                    SPI2STATbits.SPIEN = 0;
                    asm("nop");
                    SPI2STATbits.SPIEN = 1;
                    SPI2BUF;
                    break;
                case 'y':
                    SPI2STATbits.SRXMPT = 1;
                    break;
            }
        }
    }
}
/*
 * polling send/rcv
 */
void test_spi_send(void)
{
    unsigned char txc = 1;
    unsigned char rxc;
    char    sz[128];

    spi2_int_disable();
    cnint_int_disable();
//    SPI2BUF = txc++;
//    rxc = SPI2BUF;
    while(1) {
        while(SPI2STATbits.SPITBF == 0) {
            // TX
            SPI2BUF = txc++;
        }
        if (SPI2STATbits.SRXMPT == 0) {
            while(SPI2STATbits.SRXMPT == 0) {
                // RX FIFO読み出し
                rxc = SPI2BUF;
            }
#if 0
            sprintf(sz, "SPI2STAT=%04X "
                    "SPIBEC=%d SRMPT=%d SPIROV=%d SRXMPT=%d TBF=%d RBF=%d\r\n"
                    , SPI2STAT
                    , SPI2STATbits.SPIBEC
                    , SPI2STATbits.SRMPT
                    , SPI2STATbits.SPIROV
                    , SPI2STATbits.SRXMPT
                    , SPI2STATbits.SPITBF
                    , SPI2STATbits.SPIRBF
                    );
            PDEBUG(sz);
#endif
        }
    }

}
// ADレジスタgetして表示
void test_ad_get_config(void)
{
    int cs = AD_CH1_CS;
    int i;
    unsigned char   reg[9];
    char sz[64];

    ad_cs(cs);
        ad_spi_send(ADCMD_SDATAC);
    ad_cs_dis();
    ad_cs(cs);
        ad_spi_rcv(ADCMD_RREG | 0); // Register read command
        ad_spi_rcv(9 - 1);		 // 9byte write
#if 1
        for(i = 0; i < 9; i++) {
            reg[i] = ad_spi_rcv(0);
        }
#endif
    ad_cs_dis();

    for(i = 0; i < 9; i++) {
        sprintf(sz, "%d: %02X\r\n", i, reg[i]);
        PDEBUG(sz);
    }

}
#if 0
void test_ublox_rcv_mon(void)
{
    unsigned char class, id;
    unsigned int    len;
    unsigned char   payload[128];
    char    sz[128];
    UbloxNavTimeUtc *gps, gps1;

    gps = &gps1;

    while(1) {
        ublox_rcv_pkt(&class, &id, &len, payload);
        sprintf(sz, "CLASS=%02X ID=%02X LEN=%d\r\n", class, id, len);
        PDEBUG(sz);
        ublox_debug_pkt_out(payload, len);
        ublox_decode_nav_timeutc(payload, gps);
        sprintf(sz, "%04u/%02d/%02d %02d:%02d:%02d.%09ld %6lums %6luns %02X\r\n",
            gps->year, gps->month, gps->day, gps->hour, gps->min, gps->sec, gps->nano,
            gps->tow, gps->tacc, gps->valid
        );
        PDEBUG(sz);

    }
}
#endif

#if 0
/*
 * CS0〜15順番にenable
 */
void test_ad_cs()
{
    int i;

    while(1) {
        delay_ms(1000);
        ad_cs(i);
        i++;
        if (i >= 16) i = 0;
    }
}

/*
 Dataout SPI2 test
 */
void test_spi2()
{
    unsigned int    c = 0x12;
    unsigned int    rx;
    unsigned int    sts = 0;
    int i;

    i = SPI2BUF;
    while(1) {
        PORTCbits.RC9 = 1;
        delay_ms(100);
        PORTCbits.RC9 = 0;
        delay_ms(900);

//        while(spi2_tx_fifo_is_full());
//        spi2_putc(c++);
//        while(spi2_rx_fifo_is_empty());
//        rx = spi2_getc();
#if 0
        while(spi2STATbits.SPIRBF == 0);
        sts = spi2STAT;
        if (spi2STATbits.SPITBF == 0) {
            spi2BUF = c++;
        }
//        while(spi2STATbits.SPIRBF == 1) {
            i = spi2BUF;
//        }
        if (i == '$') {
            c = 0;
        }
        if (spi2STATbits.SPIROV == 1) spi2STATbits.SPIROV = 0;
        sprintf(sz, "%d %04X\r\n", i, sts);
        PDEBUG(sz);
#endif
//        while(spi2STATbits.SPITBF == 1);
//        while(spi2STATbits.SPITBF);
/*
         while(!spi2_tx_fifo_is_full())
            spi2_putc(c++);
        while(!spi2_rx_fifo_is_empty()) {
            rx = spi2_getc();
            if (rx == '$') c = 0;
        }
*/
        //        i = ReadUART1();
//        WriteUART2(i);

//        PDEBUG(mes);
//        delay();
    }
}
#endif
#if 0
void test_ad1()
{
        unsigned char in[3];
        long l[6];
        char cs;
        while(!ad_is_drdy0_enable());
//        PDEBUG("AD\r\n");
        for(cs=0; cs<6; cs++) {
            ad_cs(cs);
                in[2] = ad_spi_rcv();
                in[1] = ad_spi_rcv();
                in[0] = ad_spi_rcv();
            ad_cs_dis();
            l[cs] = byte3_to_long(in);
//            sprintf(sz, "%02X %02X %02X", in[2], in[1], in[0]);
//            PDEBUG(sz);
        }
        for(cs=0; cs<6; cs++) {
            sprintf(sz, "%+7ld,", l[cs]);
            PDEBUG(sz);
        }
        PDEBUG("\r\n");

}
#endif
