#ifndef __MYAD_H__
#include <p24FJ64GA004.h>
#include <libpic30.h>

#define __MYAD_H__

#define CS_RCLK PORTAbits.RA7
#define CS_CLK  PORTAbits.RA8
#define CS_DATA PORTAbits.RA9

#define AD_CHNUM    6
#define AD_CH1_CS   0   // AD CH1のCS番号
#define PGA_CH1_CS  6   // PGA CH1のCS番号

//#define AD_SAMPLE0  400 // AD ICの出力レート　[Hz]
//#define AD_SAMPLE1  50 // Main CPUに向けて出力するデータのサンプル数　[Hz]

#define AD_SAMPLE  50 // AD ICの出力レート　[Hz]

// SPI CMD
#define	ADCMD_SDATAC	0x11
#define	ADCMD_RREG	0x20
#define	ADCMD_WREG	0x40
#define	ADCMD_RDATAC	0x10
#define	ADCMD_SDATAC	0x11

// AD DRDY0 INTフラグ
//void ad_drdy0_intf_set(void);
//void ad_drdy0_intf_clear(void);
//char ad_is_drdy0_intf(void);

void ad_cs_init(void);
inline extern void ad_cs(unsigned char cs)
{
    unsigned char i;

//CS_CLK = 1;
    for(i = 16; i > 0; i--) {
        if (i == cs+1) {
            CS_DATA = 0;
        } else {
            CS_DATA = 1;
        }
        asm("NOP");
        CS_CLK = 1;
        CS_CLK = 0;
    }
    asm("NOP");
    CS_RCLK = 1;
    asm("NOP");
    CS_DATA = 0;
    asm("NOP");
    CS_RCLK = 0;
}

inline extern void ad_cs_dis(void){
    unsigned char i;

    CS_DATA = 1;
    for(i = 16; i > 0; i--) {
        CS_CLK = 1;
        CS_CLK = 0;
    }
    asm("NOP");
    CS_RCLK = 1;
    asm("NOP");
    CS_DATA = 0;
    asm("NOP");
    CS_RCLK = 0;
}


#define ad_reset_dis()  PORTBbits.RB10 = 1; asm("NOP")
#define ad_reset_ena()  PORTBbits.RB10 = 0; asm("NOP")

#define ad_start_dis()  PORTBbits.RB11 = 0; asm("NOP")
#define ad_start_ena()  PORTBbits.RB11 = 1; asm("NOP")

#define ad_is_drdy0_enable()    (PORTBbits.RB12 == 0)

void ad_reset(void);
void ad_start(void);
void ad_init(void);

void ad_spi_send(unsigned char c);
unsigned char ad_spi_rcv(unsigned char c);

void pga_init(void);
void pga_gain_set(int ch, int gain);

#endif
