<?php
/**
 * @copyright 2005-2006 OpenPNE Project
 * @license   http://www.php.net/license/3_01.txt PHP License 3.01
 */

class pc_page_c_trade_add_confirm extends OpenPNE_Action
{
    function execute($requests)
    {
        $u = $GLOBALS['AUTH']->uid();
        $trade = $requests;
        unset($trade['msg'], $trade['msg1'], $trade['msg2'], $trade['msg3'], $trade['sessid']);

        //--- 入力チェック
        $err_msg = array();
        if($trade['c_member_id'] == $trade['c_trade_member_id']){
            $err_msg[] = "自分への振込はできません";
        }
        //--- 権限チェック
        //コミュニティメンバー
        if (!db_commu_is_c_commu_member($trade['c_commu_id'], $u)) {
            $err_msg[] = "交換取引をおこなうにはコミュニティに参加する必要があります";
        }
        
        if ($err_msg) {
            $_REQUEST['target_c_commu_topic_id'] = $trade['c_commu_topic_id'];
            $_REQUEST['err_msg'] = $err_msg;
            openpne_forward('pc', 'page', "c_exchange_detail");
            exit;
        }
        //---
        
        $this->set('inc_navi', fetch_inc_navi("h"));
        $this->set('trade', $trade);
        return 'success';
    }
    
    function handleError($errors)
    {
        $_REQUEST = $this->requests;
        $_REQUEST['err_msg'] = array_values($errors);
        openpne_forward('pc', 'page', "c_trade_add");
        exit;
    }

}

?>
