-- new
DROP TABLE IF EXISTS c_exchange_category;
CREATE TABLE c_exchange_category (
  c_exchange_category_id int(11) NOT NULL auto_increment,
  name text NOT NULL,
  sort_order int(11) NOT NULL default '0',
  event_flag int(11) NOT NULL default '0',
  PRIMARY KEY  (c_exchange_category_id),
  KEY event_flag (event_flag)
) TYPE=MyISAM;

DROP TABLE IF EXISTS c_exchange_category_parent;
CREATE TABLE c_exchange_category_parent (
  c_exchange_category_parent_id int(11) NOT NULL auto_increment,
  name text NOT NULL,
  sort_order int(11) NOT NULL default '0',
  PRIMARY KEY  (c_exchange_category_parent_id),
  KEY sort_order (sort_order)
) TYPE=MyISAM;

DROP TABLE IF EXISTS c_commu_trade_confirm;
CREATE TABLE c_commu_trade_confirm (
  c_commu_trade_confirm_id int(11) NOT NULL auto_increment,  
  c_commu_topic_id int(11) NOT NULL default '0', 
  c_member_id int(11) NOT NULL default '0', 
  c_trade_member_id int(11) NOT NULL default '0', 
  amount double NOT NULL default '0', 
  add_amount double NOT NULL default '0', 
  message text NOT NULL,   
  r_datetime datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (c_commu_trade_confirm_id),   
  KEY c_member_id (c_member_id)   
) TYPE=MyISAM;

DROP TABLE IF EXISTS c_commu_trade;
CREATE TABLE c_commu_trade (
  c_commu_trade_id int(11) NOT NULL auto_increment,  
  c_commu_topic_id int(11) NOT NULL default '0', 
  c_member_id int(11) NOT NULL default '0', 
  c_trade_member_id int(11) NOT NULL default '0', 
  amount double NOT NULL default '0', 
  add_amount double NOT NULL default '0', 
  message text NOT NULL,   
  balance double NOT NULL default '0', 
  r_datetime datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (c_commu_trade_id),   
  KEY c_member_id (c_member_id)   
) TYPE=MyISAM;

-- override
DROP TABLE IF EXISTS c_commu_topic;
CREATE TABLE c_commu_topic (
  c_commu_topic_id int(11) NOT NULL auto_increment,  
  c_commu_id int(11) NOT NULL default '0', 
  name text NOT NULL,   
  r_datetime datetime NOT NULL default '0000-00-00 00:00:00',
  r_date date NOT NULL default '0000-00-00', 
  c_member_id int(11) NOT NULL default '0', 
  open_date date NOT NULL default '0000-00-00', 
  open_date_comment varchar(100) NOT NULL default '', 
  open_pref_id int(11) NOT NULL default '0', 
  open_pref_comment varchar(100) NOT NULL default '', 
  invite_period date NOT NULL default '0000-00-00', 
  event_flag int(11) NOT NULL default '0', 
  close_date date NOT NULL default '0000-00-00', 
  close_date_comment varchar(100) NOT NULL default '', 
  c_exchange_category_id int(11) NOT NULL default '0', 
  amount double NOT NULL default '0', 
  add_amount double NOT NULL default '0', 
  is_display_map tinyint(1) NOT NULL default '0', 
  map_latitude double NOT NULL default '0', 
  map_longitude double NOT NULL default '0', 
  map_zoom int(11) NOT NULL default '0', 
  PRIMARY KEY  (c_commu_topic_id),
  KEY c_member_id (c_member_id),
  KEY c_commu_id (c_commu_id)
) TYPE=MyISAM;

