/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * RBTOS ̃Xbh؊Ȃǂ̃AZuR[h
 * $Id: rbtos_asm.S 28 2012-11-17 15:09:43Z xeerda $
 *****************************************************************************/
#include "rbtos_asm.inc"


	.extern _StackErrorFunc
	.global __StackError
__StackError:
	MOV		[W15 - 4], W0
	MOV		[W15 - 2], W1
	MOV		SPLIM, W2
	MOV		W15, W3
	bra		_StackErrorFunc


/*****************************************************************************
 * ^C} 1
 *****************************************************************************/
	.extern _T1InterruptFunc
	.global	__T1Interrupt
__T1Interrupt:
	RBTOS_PREV_INTERRUPT
	
	call	_T1InterruptFunc
	
	RBTOS_AFTER_INTERRUPT



	.global __iRBTOS_end_interrupt
__iRBTOS_end_interrupt:
	MOV	#0xE0, W2		// [U[֎~
	MOV	W2, SR			//  :
	
	MOV.B	[W15 - 27], W0		// d̏ꍇCXbh؊Ȃ
	MOV	#0xE0, W1		//   : SPL QƂđdۂ𔻒f
	AND	W0, W1, W0		//   :
	BRA	NZ, ExitISR		//   :
	
	MOV	_pCurThread, W0		// pCurThread  lsActvThreads Ȃ
	MOV	_lsActvThreads, W1	// Xbh؊s.
	CP	W0, W1			//   :
	BRA	NZ, F020_Thread_switch	//   :
ExitISR:
	POP	PSVPAG			// Xbh؊I鏈
	POP	CORCON			//
	POP	TBLPAG			//
	POP	RCOUNT			//
	POP.D	W6			//
	POP.D	W4			//
	POP.D	W2			//
	POP.D	W0			//
	POP	SR			//
	retfie				//

	.global _lsActvThreads
	.global _pCurThread
F020_Thread_switch:
	PUSH.D 	W8			// +16: W8:W9
	PUSH.D 	W10			// +18: W10:W11
	PUSH.D	W12			// +20: W12:W13
	PUSH	W14			// +22: W14
	
	MOV	_lsActvThreads, W0	// 
	MOV	_pCurThread, W1		// 
L010:
	MOV	W15, [W1]		// store W15 to pCurThread->pLastSP
	MOV	#0xFFFE, W1		// ꎞIɃX^bNI[o[t[`FbN OFF
	MOV	W1, SPLIM		//   :
	
	MOV	W0, _pCurThread		// pCurThread  lsActvThreads
	MOV	[W0], W15		// W15  pCurThread->pLastSP
	MOV	[W0 + 2], W0		// SPLIM  pCurThread->splim
	MOV	W0, SPLIM		//  :
	POP	W14
	POP.D	W12
	POP.D	W10
	POP.D	W8
	POP	PSVPAG
	POP	CORCON
	POP	TBLPAG
	POP	RCOUNT
	POP.D	W6
	POP.D	W4
	POP.D	W2
	POP.D	W0
	POP	SR			
	retfie


	.global	_RBTOS_get_main_splim
_RBTOS_get_main_splim:
	MOV	SPLIM, W0
	RETURN

/*****************************************************************************
 * ^XNXCb`
 * void RBTOS_Thread_switch(RBTOS_ThreadT *next)
 * ݎs̃^XN(_pCurThread) ̃^XNReLXgۑC
 * ɃANeBuɂȂ^XN(next) ̃^XNReLXg𕜋A܂.
 * ̊֐ĂԑOɁC^XNXg^XN؊̏ԂɂĂ܂.
 *****************************************************************************/
        .global _RBTOS_Thread_switch
	.extern _pCurThread
_RBTOS_Thread_switch:
	MOV	_lsActvThreads, W0
	MOV	_pCurThread, W1
	CP	W0, W1
	BRA	NZ, F010
	RETURN
F010:		
	MOV	SR, W2		// IPL<2>~<0>NA SRL
	MOV	#0xFF1F, W3	//   :
	AND	W2, W3, W2	//   :
	MOV.B	W2, [W15 - 1]	// retfie Ń^[̂
	MOV	#0x00E0, W3	//
	PUSH	W3		// 
	PUSH.D	W0		//
	PUSH.D	W2		//
	PUSH.D	W4		// +2: W4:W5
	PUSH.D	W6		// +4: W6:W7
	PUSH	RCOUNT		// +6:
	PUSH	TBLPAG		// +7:
	PUSH	CORCON		// +8:
	PUSH	PSVPAG		// +9:
	PUSH.D 	W8		// +16: W8:W9
	PUSH.D 	W10		// +18: W10:W11
	PUSH.D	W12		// +20: W12:W13
	PUSH	W14		// +22: W14
	MOV	W3, SR		// [U[֎~
	BRA	L010
        .end
