#pragma once




namespace geom
{


class BoneWeight
{
public:
	BoneWeight(void):
		m_Vid(-1),
		m_Weight(0.0f)
	{
	}

public:
	int m_Vid;
	float m_Weight;
};


class Bone
{
public:
	lm::matrix4f GetFrameMatrix(int frame)
	{
		lm::matrix4f mt = lm::matrix4f::get_identity();

		if(!m_Rotate.empty())
		{
			float vel;
			lm::vec3f ax;
			m_Rotate[frame].get_rotate_params(ax, vel);
			mt *= lm::matrix4f::get_rotate(ax, vel);
		}

		if(!m_Scale.empty())
		{
			lm::vec3f s = m_Scale[frame];
			mt *= lm::matrix4f::get_scale(s.x, s.y, s.z);
		}

		if(!m_Translate.empty())
		{
			lm::vec3f d = m_Translate[frame];
			mt *= lm::matrix4f::get_translate(d);
		}

		return mt;
	}

public:
	std::string m_Name;
	lm::matrix4f m_Offset;
	lm::matrix4f m_NodeTrans;

	std::vector<BoneWeight> m_Weights;

	std::vector<lm::vec3f>  m_Translate;
	std::vector<lm::quat4f> m_Rotate;
	std::vector<lm::vec3f>  m_Scale;

	std::vector<Bone*> m_Children;
};


class BoneRoot
{
public:
	lm::matrix4f m_Transform;
	Bone* m_Bone;
};


class BoneAnimation
{
public:
	void Clear(void)
	{
		m_Bones.clear();
		m_SrcVertPos.clear();
		m_RootNodes.clear();
	}

public:
	boost::ptr_vector<Bone> m_Bones;

	std::vector<lm::vec3f> m_SrcVertPos;

	std::vector<BoneRoot> m_RootNodes;
};


}
