#pragma once

#include <QString>
#include <QFile>
#include <QVector>


class QtLockedFile : public QFile
{
public:
	enum LockMode
	{
		NoLock = 0,
		ReadLock,
		WriteLock
	};

	QtLockedFile();
	QtLockedFile(const QString &name);
	~QtLockedFile();

	bool open(OpenMode mode);

	bool lock(LockMode mode, bool block = true);
	bool unlock();
	bool isLocked() const;
	LockMode lockMode() const;

private:
	Qt::HANDLE wmutex;
	Qt::HANDLE rmutex;
	QVector<Qt::HANDLE> rmutexes;
	QString mutexname;

	Qt::HANDLE getMutexHandle(int idx, bool doCreate);
	bool waitMutex(Qt::HANDLE mutex, bool doBlock);

	LockMode m_lock_mode;
};
