#pragma once

#include <C2/lm/vector3.h>



namespace lib_geo
{


class BaryCoord
{
public:
	BaryCoord(void) :
		Fid(-1),
		Subface(-1)
	{
	}

	BaryCoord(int fid, int subface, const lm::vec3f& bc) :
		Fid(fid),
		Subface(subface),
		Bary(bc)
	{
	}

	void Set(int fid, int subface, const lm::vec3f& bc)
	{
		Fid = fid;
		Subface = subface;
		Bary = bc;
	}

	void Reset(void)
	{
		Fid = -1;
		Subface = -1;
		Bary.set(0.0f, 0.0f, 0.0f);
	}

	bool IsValid(void) const
	{
		if (Fid == -1)
			return false;

		if (Subface == -1)
			return false;

		return true;
	}


public:
	int Fid;
	int Subface;
	lm::vec3f Bary;
};


}
